/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractChargeAttack;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class HorusDivekickAttack
extends AbstractChargeAttack<HorusDivekickAttack, HorusEntity, HorusEntity.State> {
    private static final MobEffectInstance LEVITATE = new MobEffectInstance(MobEffects.f_19591_, 9, 4, true, false);
    private Vec3 lookDir = Vec3.f_82478_;

    public HorusDivekickAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, HorusEntity.State.DIVEKICK_HIT);
        this.withMobilityType(MobilityType.FLIGHT);
    }

    @Override
    @NotNull
    public MoveType<HorusDivekickAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(HorusEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUserOrThrow();
        if (attacker.isFree()) {
            attacker.setFree(false);
        }
        this.lookDir = user.m_20154_().m_82490_(0.95);
        int duration = 20 + (int)user.m_146909_();
        if (duration < this.getWindup()) {
            duration = this.getWindup();
        }
        this.withDuration(duration);
        user.m_7292_(new MobEffectInstance(LEVITATE));
    }

    @Override
    protected void endCharge(HorusEntity attacker) {
        super.endCharge(attacker);
        Vec3 newPos = this.advanceChargePos(attacker, this.getMoveDistance(), this.getWindupPoint());
        attacker.setFreePos(new Vector3f((float)newPos.f_82479_, (float)newPos.f_82480_, (float)newPos.f_82481_));
    }

    @Override
    protected Vec3 advanceChargePos(StandEntity<?, ?> attacker, float moveDistance, int windupPoint) {
        return attacker.m_20182_().m_82549_(this.lookDir);
    }

    @Override
    protected void tickChargeAttack(StandEntity<HorusEntity, HorusEntity.State> attacker, boolean shouldPerform, float moveDistance, int windupPoint) {
        super.tickChargeAttack(attacker, shouldPerform, moveDistance, windupPoint);
        if (attacker.getMoveStun() < windupPoint) {
            if (attacker.m_20075_().m_60815_()) {
                this.endCharge((HorusEntity)attacker);
            } else {
                LivingEntity user = attacker.getUserOrThrow();
                GravityChangerAPI.setWorldVelocity((Entity)user, this.lookDir);
                JUtils.syncVelocityUpdate((Entity)user);
                user.m_183634_();
            }
        }
    }

    @Override
    @NonNull
    protected HorusDivekickAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public HorusDivekickAttack copy() {
        return this.copyExtras(new HorusDivekickAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<HorusDivekickAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<HorusDivekickAttack>, HorusDivekickAttack> buildCodec(RecordCodecBuilder.Instance<HorusDivekickAttack> instance) {
            return this.attackDefault(instance, HorusDivekickAttack::new);
        }
    }
}

