/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.LargeIcicleProjectile;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class IceLanceAttack
extends AbstractMove<IceLanceAttack, HorusEntity> {
    public IceLanceAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<IceLanceAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        AbstractMove move = attacker.getCurrentMove();
        if (move == null) {
            return Set.of();
        }
        LargeIcicleProjectile icicle = new LargeIcicleProjectile(attacker.m_9236_(), user);
        attacker.setLastLargeIcicle(icicle);
        Vec3i gravity = GravityChangerAPI.getGravityDirection((Entity)user).m_122436_();
        Vec3 velocity = user.m_20154_();
        double e = velocity.f_82479_;
        double f = velocity.f_82480_;
        double g = velocity.f_82481_;
        double l = velocity.m_165924_();
        icicle.m_7678_(attacker.m_20185_() - (double)gravity.m_123341_() * 1.5, attacker.m_20186_() - (double)gravity.m_123342_() * 1.5, attacker.m_20189_() - (double)gravity.m_123343_() * 1.5, (float)(Mth.m_14136_((double)(-e), (double)(-g)) * 57.2957763671875), (float)(Mth.m_14136_((double)f, (double)l) * 57.2957763671875));
        icicle.m_20256_(velocity.m_82490_(1.75));
        icicle.markProjectile();
        icicle.lock();
        attacker.m_9236_().m_7967_((Entity)icicle);
        return Set.of();
    }

    @Override
    @NonNull
    protected IceLanceAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public IceLanceAttack copy() {
        return this.copyExtras(new IceLanceAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<IceLanceAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<IceLanceAttack>, IceLanceAttack> buildCodec(RecordCodecBuilder.Instance<IceLanceAttack> instance) {
            return this.baseDefault(instance, IceLanceAttack::new);
        }
    }
}

