/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.LargeIcicleProjectile;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class IcicleFireAttack
extends AbstractMove<IcicleFireAttack, HorusEntity> {
    public static int MAX_ICICLE_CHARGE_TIME = 30;

    public IcicleFireAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<IcicleFireAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean shouldPerform(HorusEntity attacker, int moveStun) {
        return super.shouldPerform(attacker, moveStun);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        LargeIcicleProjectile instantIcicle = new LargeIcicleProjectile(attacker.m_9236_(), user);
        float scale = Mth.m_14036_((float)((float)this.getChargeTime() / ((float)MAX_ICICLE_CHARGE_TIME - 2.0f)), (float)0.1f, (float)1.0f);
        instantIcicle.setScale(scale);
        instantIcicle.setInstant(true);
        Vec3 heightOffset = GravityChangerAPI.getEyeOffset((Entity)user).m_82490_(0.75);
        Vec3 velocity = user.m_20154_().m_82490_(0.01);
        double e = velocity.f_82479_;
        double f = velocity.f_82480_;
        double g = velocity.f_82481_;
        double l = velocity.m_165924_();
        instantIcicle.m_7678_(attacker.m_20185_() + heightOffset.f_82479_, attacker.m_20186_() + heightOffset.f_82480_, attacker.m_20189_() + heightOffset.f_82481_, (float)(Mth.m_14136_((double)(-e), (double)(-g)) * 57.2957763671875), (float)(Mth.m_14136_((double)f, (double)l) * 57.2957763671875));
        instantIcicle.m_20256_(velocity);
        instantIcicle.lock();
        attacker.m_9236_().m_7967_((Entity)instantIcicle);
        return Set.of();
    }

    @Override
    @NonNull
    protected IcicleFireAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public IcicleFireAttack copy() {
        return this.copyExtras(new IcicleFireAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<IcicleFireAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<IcicleFireAttack>, IcicleFireAttack> buildCodec(RecordCodecBuilder.Instance<IcicleFireAttack> instance) {
            return this.baseDefault(instance, IcicleFireAttack::new);
        }
    }
}

