/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.projectile.IceBranchProjectile;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;

public class PerfectFreezeAttack
extends AbstractSimpleAttack<PerfectFreezeAttack, HorusEntity> {
    public PerfectFreezeAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<PerfectFreezeAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        int NUM_BRANCHES = 3;
        for (int i = 0; i < 3; ++i) {
            IceBranchProjectile iceBranch = new IceBranchProjectile(attacker.m_9236_(), user, 0);
            iceBranch.m_7678_(attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), -attacker.m_146908_() + 180.0f, -attacker.m_146909_());
            iceBranch.m_146922_(iceBranch.m_146908_() + 360.0f * (float)i / 3.0f);
            attacker.m_9236_().m_7967_((Entity)iceBranch);
        }
        attacker.m_9236_().m_45976_(Projectile.class, attacker.m_20191_().m_82400_(5.0)).forEach(p -> JUtils.setVelocity((Entity)p, 0.0, 0.0, 0.0));
        JCraft.createParticle((ServerLevel)attacker.m_9236_(), attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), JParticleType.FLASH);
        targets.forEach(t -> t.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, false, true)));
        return targets;
    }

    @Override
    @NonNull
    protected PerfectFreezeAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public PerfectFreezeAttack copy() {
        return this.copyExtras(new PerfectFreezeAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<PerfectFreezeAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<PerfectFreezeAttack>, PerfectFreezeAttack> buildCodec(RecordCodecBuilder.Instance<PerfectFreezeAttack> instance) {
            return this.attackDefault(instance, PerfectFreezeAttack::new);
        }
    }
}

