/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.IcicleProjectile;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ScatterAttack
extends AbstractMove<ScatterAttack, HorusEntity> {
    public ScatterAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<ScatterAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        for (int batch = 0; batch < 2; ++batch) {
            float offset = batch == 0 ? 10.0f : -10.0f;
            for (int i = 1; i < 4; ++i) {
                IcicleProjectile icicle = new IcicleProjectile(attacker.m_9236_(), user);
                float pitch = user.m_146909_();
                float yaw = user.m_146908_() + (float)i * offset;
                Vec3 rotVec = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(yaw, pitch), GravityChangerAPI.getGravityDirection((Entity)user));
                icicle.m_6686_(rotVec.f_82479_, rotVec.f_82480_, rotVec.f_82481_, 1.75f, 0.1f);
                Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)attacker.getUserOrThrow());
                Vec3 heightOffset = upVec.m_82490_(0.75);
                icicle.m_146884_(attacker.getBaseEntity().m_20182_().m_82549_(heightOffset));
                icicle.withReflect();
                attacker.m_9236_().m_7967_((Entity)icicle);
            }
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected ScatterAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public ScatterAttack copy() {
        return this.copyExtras(new ScatterAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<ScatterAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ScatterAttack>, ScatterAttack> buildCodec(RecordCodecBuilder.Instance<ScatterAttack> instance) {
            return this.baseDefault(instance, ScatterAttack::new);
        }
    }
}

