/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.horus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.projectile.LargeIcicleProjectile;
import net.arna.jcraft.common.entity.stand.HorusEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class StompAttack
extends AbstractSimpleAttack<StompAttack, HorusEntity> {
    public StompAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<StompAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(HorusEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        LargeIcicleProjectile icicle = new LargeIcicleProjectile(attacker.m_9236_(), user);
        attacker.setLastLargeIcicle(icicle);
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)user);
        Vec3 velocity = attacker.isFree() || !user.m_20096_() ? attacker.m_20154_().m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, -1.0, 0.0), gravity)).m_82490_(0.01) : user.m_20154_().m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, 1.0, 0.0), gravity)).m_82490_(0.01);
        double e = velocity.f_82479_;
        double f = velocity.f_82480_;
        double g = velocity.f_82481_;
        double l = velocity.m_165924_();
        icicle.m_7678_(attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (float)(Mth.m_14136_((double)(-e), (double)(-g)) * 57.2957763671875), (float)(Mth.m_14136_((double)f, (double)l) * 57.2957763671875));
        icicle.m_20256_(velocity);
        icicle.lock();
        attacker.m_9236_().m_7967_((Entity)icicle);
        attacker.m_216990_((SoundEvent)JSoundRegistry.HORUS_STOMP_SLAM.get());
        return targets;
    }

    @Override
    @NonNull
    protected StompAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public StompAttack copy() {
        return this.copyExtras(new StompAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<StompAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<StompAttack>, StompAttack> buildCodec(RecordCodecBuilder.Instance<StompAttack> instance) {
            return this.attackDefault(instance, StompAttack::new);
        }
    }
}

