/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonBombTrackerComponent;
import net.arna.jcraft.common.entity.stand.AbstractKillerQueenEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BombPlantAttack
extends AbstractSimpleAttack<BombPlantAttack, AbstractKillerQueenEntity<?, ?>> {
    private static final Vec3 halfBox = new Vec3(0.5, 0.5, 0.5);

    public BombPlantAttack(int cooldown, int windup, int duration, float moveDistance, int stun, float hitboxSize, float offset) {
        super(cooldown, windup, duration, moveDistance, 0.0f, stun, hitboxSize, 0.0f, offset);
    }

    @Override
    @NotNull
    public MoveType<BombPlantAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AbstractKillerQueenEntity<?, ?> attacker, LivingEntity user) {
        CommonBombTrackerComponent.BombData mainBomb = JComponentPlatformUtils.getBombTracker(user).getMainBomb();
        Set<LivingEntity> targets = super.perform(attacker, user);
        Vec3 rotVec = BombPlantAttack.getRotVec(attacker);
        Vec3 boxCenter = attacker.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld(new Vec3(0.0, (double)attacker.m_20206_() * 0.66, 0.0), GravityChangerAPI.getGravityDirection(attacker))).m_82549_(rotVec);
        targets.stream().findFirst().map(JUtils::getUserIfStand).or(() -> {
            List hit = attacker.m_9236_().m_6443_(Entity.class, new AABB(boxCenter.m_82546_(halfBox), boxCenter.m_82549_(halfBox)), EntitySelector.f_20406_.and(e -> e != attacker && e != user));
            return hit.isEmpty() ? Optional.empty() : Optional.of((Entity)hit.get(0));
        }).ifPresentOrElse(mainBomb::setBomb, () -> {
            BlockPos closePos = BlockPos.m_274446_((Position)boxCenter.m_82546_(rotVec));
            BlockPos farPos = BlockPos.m_274446_((Position)boxCenter);
            BlockState blockState = attacker.m_9236_().m_8055_(closePos);
            if (blockState.m_60795_()) {
                blockState = attacker.m_9236_().m_8055_(farPos);
                if (!blockState.m_60795_()) {
                    mainBomb.setBomb(farPos);
                }
            } else {
                mainBomb.setBomb(closePos);
            }
        });
        return targets;
    }

    @Override
    @NonNull
    protected BombPlantAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BombPlantAttack copy() {
        return this.copyExtras(new BombPlantAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getStun(), this.getHitboxSize(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<BombPlantAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<BombPlantAttack>, BombPlantAttack> buildCodec(RecordCodecBuilder.Instance<BombPlantAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.stun(), this.hitboxSize(), this.offset()).apply(instance, this.applyAttackExtras(BombPlantAttack::new));
        }
    }
}

