/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JItemRegistry;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.KillerQueenEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class CoinTossMove
extends AbstractMove<CoinTossMove, KillerQueenEntity> {
    private WeakReference<ItemEntity> coin = new WeakReference<Object>(null);

    public CoinTossMove(int cooldown) {
        super(cooldown, 0, 0, 1.0f);
        this.ranged = true;
    }

    @Override
    @NotNull
    public MoveType<CoinTossMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KillerQueenEntity attacker, LivingEntity user) {
        ItemEntity coin = (ItemEntity)this.coin.get();
        Vec3 lookVec = user.m_20154_().m_82490_(0.75);
        if (coin != null) {
            coin.m_146870_();
        }
        coin = new ItemEntity(attacker.m_9236_(), user.m_20185_(), user.m_20186_() + (double)(user.m_20206_() * 2.0f / 3.0f), user.m_20189_(), new ItemStack((ItemLike)JItemRegistry.KQ_COIN.get(), 1), lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_);
        coin.m_32062_();
        attacker.m_9236_().m_7967_((Entity)coin);
        JComponentPlatformUtils.getBombTracker(user).getMainBomb().setBomb((Entity)coin);
        attacker.m_5496_((SoundEvent)JSoundRegistry.COIN_TOSS.get(), 1.0f, 1.0f);
        this.coin = new WeakReference<ItemEntity>(coin);
        return Set.of();
    }

    @Override
    @NonNull
    protected CoinTossMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public CoinTossMove copy() {
        return this.copyExtras(new CoinTossMove(this.getCooldown()));
    }

    public static class Type
    extends AbstractMove.Type<CoinTossMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<CoinTossMove>, CoinTossMove> buildCodec(RecordCodecBuilder.Instance<CoinTossMove> instance) {
            return instance.group(this.extras(), this.cooldown()).apply(instance, this.applyExtras(CoinTossMove::new));
        }
    }
}

