/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.AbstractKillerQueenEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class ExplosiveDashAttack
extends AbstractMove<ExplosiveDashAttack, AbstractKillerQueenEntity<?, ?>> {
    public ExplosiveDashAttack(int cooldown) {
        super(cooldown, 0, 0, 0.0f);
        this.dash = true;
    }

    @Override
    @NotNull
    public MoveType<ExplosiveDashAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AbstractKillerQueenEntity<?, ?> attacker, LivingEntity user) {
        Vec3 lookVec = user.m_20154_().m_82490_(0.9);
        attacker.m_9236_().m_254849_((Entity)user, user.m_20185_() - lookVec.f_82479_, user.m_20186_() + (double)(user.m_20206_() / 2.0f) - lookVec.f_82480_, user.m_20189_() - lookVec.f_82481_, 1.0f, Level.ExplosionInteraction.NONE);
        user.m_20256_(user.m_20184_().m_82549_(lookVec));
        user.f_19864_ = true;
        attacker.m_5496_((SoundEvent)JSoundRegistry.KQ_DETONATE.get(), 1.0f, 1.0f);
        return Set.of();
    }

    @Override
    @NonNull
    protected ExplosiveDashAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public ExplosiveDashAttack copy() {
        return this.copyExtras(new ExplosiveDashAttack(this.getCooldown()));
    }

    public static class Type
    extends AbstractMove.Type<ExplosiveDashAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ExplosiveDashAttack>, ExplosiveDashAttack> buildCodec(RecordCodecBuilder.Instance<ExplosiveDashAttack> instance) {
            return instance.group(this.extras(), this.cooldown()).apply(instance, this.applyExtras(ExplosiveDashAttack::new));
        }
    }
}

