/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.component.living.CommonBombTrackerComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.projectile.BubbleProjectile;
import net.arna.jcraft.common.entity.stand.AbstractKillerQueenEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class KQDetonateAttack
extends AbstractMove<KQDetonateAttack, AbstractKillerQueenEntity<?, ?>> {
    public KQDetonateAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<KQDetonateAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AbstractKillerQueenEntity<?, ?> attacker, LivingEntity user) {
        CommonBombTrackerComponent.BombData bombData = JComponentPlatformUtils.getBombTracker(user).getMainBomb();
        Entity bombEntity = bombData.bombEntity;
        Vec3 bombPos = bombData.getBombPos();
        if (bombPos != null) {
            if (bombEntity instanceof ItemEntity || bombEntity instanceof BubbleProjectile) {
                bombEntity.m_146870_();
            }
            KQDetonateAttack.explode(attacker, (Entity)user, bombPos);
        }
        bombData.reset();
        return Set.of();
    }

    @Override
    public MoveSelectionResult specificMoveSelectionCriterion(AbstractKillerQueenEntity<?, ?> attacker, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        Vec3 bombPos = JComponentPlatformUtils.getBombTracker(mob).getMainBomb().getBombPos();
        return bombPos != null && target.m_20238_(bombPos) < 9.0 ? MoveSelectionResult.USE : MoveSelectionResult.STOP;
    }

    @Override
    @NonNull
    protected KQDetonateAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public KQDetonateAttack copy() {
        return this.copyExtras(new KQDetonateAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static void explode(AbstractKillerQueenEntity<?, ?> stand, Entity user, Vec3 pos) {
        ServerLevel serverWorld = (ServerLevel)stand.m_9236_();
        JCraft.createParticle(serverWorld, pos.f_82479_, pos.f_82480_, pos.f_82481_, JParticleType.BOOM);
        JUtils.serverPlaySound((SoundEvent)JSoundRegistry.KQ_EXPLODE.get(), serverWorld, pos, 96.0);
        DamageSource damageSource = JDamageSources.stand(stand);
        Set<LivingEntity> toExplode = AbstractSimpleAttack.findHits(stand, pos, 4.4, damageSource);
        for (LivingEntity living : toExplode) {
            Vec3 kbVec = living.m_146892_().m_82546_(pos).m_82541_();
            Attacks.damageLogic(stand.m_9236_(), living, kbVec, 2, 3, true, 11.0f, false, 4, damageSource, user, null);
            living.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 35, 0, true, false));
        }
    }

    public static class Type
    extends AbstractMove.Type<KQDetonateAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<KQDetonateAttack>, KQDetonateAttack> buildCodec(RecordCodecBuilder.Instance<KQDetonateAttack> instance) {
            return this.baseDefault(instance, KQDetonateAttack::new);
        }
    }
}

