/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.StateContainer;
import net.arna.jcraft.api.attack.moves.AbstractGrabAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.KillerQueenEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class KQGrabAttack
extends AbstractGrabAttack<KQGrabAttack, KillerQueenEntity, KillerQueenEntity.State> {
    public KQGrabAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, AbstractMove<?, ? super KillerQueenEntity> hitMove) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMove, StateContainer.of(KillerQueenEntity.State.GRAB_HIT));
    }

    @Override
    @NotNull
    public MoveType<KQGrabAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KillerQueenEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        targets.stream().findFirst().ifPresent(JComponentPlatformUtils.getBombTracker(user).getMainBomb()::setBomb);
        return targets;
    }

    @Override
    @NonNull
    protected KQGrabAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public KQGrabAttack copy() {
        return this.copyExtras(new KQGrabAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getHitMove()));
    }

    public static class Type
    extends AbstractGrabAttack.Type<KQGrabAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<KQGrabAttack>, KQGrabAttack> buildCodec(RecordCodecBuilder.Instance<KQGrabAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.hitMove()).apply(instance, this.applyAttackExtras(KQGrabAttack::new));
        }
    }
}

