/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonBombTrackerComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.KillerQueenEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class KQGrabHitAttack
extends AbstractMove<KQGrabHitAttack, KillerQueenEntity> {
    private final int stun;

    public KQGrabHitAttack(int cooldown, int windup, int duration, float moveDistance, int stun) {
        super(cooldown, windup, duration, moveDistance);
        this.stun = stun;
    }

    @Override
    @NotNull
    public MoveType<KQGrabHitAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KillerQueenEntity attacker, LivingEntity user) {
        attacker.m_5496_((SoundEvent)JSoundRegistry.KQ_DETONATE.get(), 1.0f, 1.0f);
        CommonBombTrackerComponent.BombData bombData = JComponentPlatformUtils.getBombTracker(user).getMainBomb();
        Entity entity = bombData.bombEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            Vec3 pos = livingEntity.m_20182_();
            JCraft.createParticle(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, JParticleType.BOOM);
            JUtils.serverPlaySound((SoundEvent)JSoundRegistry.KQ_EXPLODE.get(), world, pos, 96.0);
            DamageSource damageSource = JDamageSources.stand(attacker);
            Attacks.damageLogic((Level)world, livingEntity, new Vec3(0.0, 1.0, 0.0), this.stun, 3, true, 11.0f, false, 4, damageSource, (Entity)user, null);
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 35, 0, true, false));
        }
        bombData.reset();
        return Set.of();
    }

    @Override
    @NonNull
    protected KQGrabHitAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public KQGrabHitAttack copy() {
        return this.copyExtras(new KQGrabHitAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getStun()));
    }

    public int getStun() {
        return this.stun;
    }

    public static class Type
    extends AbstractMove.Type<KQGrabHitAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<KQGrabHitAttack>, KQGrabHitAttack> buildCodec(RecordCodecBuilder.Instance<KQGrabHitAttack> instance) {
            return this.baseDefault(instance).and((App)Codec.INT.fieldOf("stun").forGetter(KQGrabHitAttack::getStun)).apply(instance, this.applyExtras(KQGrabHitAttack::new));
        }
    }
}

