/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.KQBTDEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BTDDetonateAttack
extends AbstractMove<BTDDetonateAttack, KQBTDEntity> {
    public BTDDetonateAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<BTDDetonateAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KQBTDEntity attacker, LivingEntity user) {
        LivingEntity btdEntity = (LivingEntity)attacker.getBtdEntity().get();
        Vec3 btdPos = attacker.getBtdPos();
        if (btdEntity == null) {
            return Set.of();
        }
        attacker.m_9236_().m_254849_((Entity)user, btdEntity.m_20185_(), btdEntity.m_20186_() + (double)(btdEntity.m_20206_() / 2.0f), btdEntity.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
        btdEntity.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 35, 0, true, false));
        Vec3 pos = btdEntity.m_20182_();
        JCraft.createParticle((ServerLevel)attacker.m_9236_(), pos.f_82479_, pos.f_82480_ + 5.0, pos.f_82481_, JParticleType.BITES_THE_DUST);
        Vec3 v1 = pos.m_82520_(3.0, 3.0, 3.0);
        Vec3 v2 = pos.m_82520_(-3.0, -3.0, -3.0);
        List list = attacker.m_9236_().m_6443_(LivingEntity.class, new AABB(v1, v2), EntitySelector.f_20403_.and(e -> e != user.m_20202_() && e != user && e != attacker && e != btdEntity));
        for (LivingEntity l : list) {
            if (!(l.m_20238_(pos) < 9.0)) continue;
            if (l.m_20238_(pos) < 2.25) {
                attacker.m_9236_().m_254849_((Entity)user, l.m_20185_(), l.m_20186_() + (double)(l.m_20206_() / 2.0f), l.m_20189_(), 1.5f, Level.ExplosionInteraction.NONE);
                continue;
            }
            attacker.m_9236_().m_254849_((Entity)user, l.m_20185_(), l.m_20186_() + (double)(l.m_20206_() / 2.0f), l.m_20189_(), 1.0f, Level.ExplosionInteraction.NONE);
        }
        btdEntity.m_20324_(btdPos.f_82479_, btdPos.f_82480_, btdPos.f_82481_);
        attacker.setBtdEntity(new WeakReference<Object>(null));
        attacker.setBtdPos(null);
        return Set.of();
    }

    @Override
    @NonNull
    protected BTDDetonateAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BTDDetonateAttack copy() {
        return this.copyExtras(new BTDDetonateAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<BTDDetonateAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BTDDetonateAttack>, BTDDetonateAttack> buildCodec(RecordCodecBuilder.Instance<BTDDetonateAttack> instance) {
            return this.baseDefault(instance, BTDDetonateAttack::new);
        }
    }
}

