/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.attack.moves.killerqueen.KQDetonateAttack;
import net.arna.jcraft.common.entity.stand.KQBTDEntity;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class BTDGrabHitAttack
extends AbstractMultiHitAttack<BTDGrabHitAttack, KQBTDEntity> {
    public BTDGrabHitAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
    }

    @Override
    @NotNull
    public MoveType<BTDGrabHitAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KQBTDEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        switch (this.getBlow(attacker)) {
            case 0: {
                for (LivingEntity ent : targets) {
                    ent.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 40, 0, true, false, true));
                }
                break;
            }
            case 2: {
                KQDetonateAttack.explode(attacker, (Entity)user, attacker.m_20182_().m_82492_(0.0, 0.5, 0.0));
            }
        }
        return targets;
    }

    @Override
    @NonNull
    protected BTDGrabHitAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BTDGrabHitAttack copy() {
        return this.copyExtras(new BTDGrabHitAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments()));
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<BTDGrabHitAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BTDGrabHitAttack>, BTDGrabHitAttack> buildCodec(RecordCodecBuilder.Instance<BTDGrabHitAttack> instance) {
            return this.multiHitDefault(instance, BTDGrabHitAttack::new);
        }
    }
}

