/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.KQBTDEntity;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class BTDPlantAttack
extends AbstractSimpleAttack<BTDPlantAttack, KQBTDEntity> {
    public BTDPlantAttack(int cooldown, int windup, int duration, float moveDistance, int stun, float hitboxSize, float offset) {
        super(cooldown, windup, duration, moveDistance, 0.0f, stun, hitboxSize, 0.0f, offset);
    }

    @Override
    @NotNull
    public MoveType<BTDPlantAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(KQBTDEntity attacker) {
        if (attacker.hasUser()) {
            this.tickBomb(attacker);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KQBTDEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            return Set.of();
        }
        LivingEntity btdEntity = JUtils.getUserIfStand((LivingEntity)targets.stream().findFirst().orElseThrow());
        if (btdEntity instanceof LivingEntity) {
            LivingEntity living = btdEntity;
            attacker.setBtdEntity(new WeakReference<LivingEntity>(living));
            attacker.setBtdPos(btdEntity.m_20182_());
        }
        return targets;
    }

    public void tickBomb(KQBTDEntity stand) {
        LivingEntity livingEntity = stand.getUser();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.displayBTDParticles(stand, player);
        }
    }

    private void displayBTDParticles(KQBTDEntity stand, ServerPlayer playerEntity) {
        Entity bombEntity = (Entity)stand.getBtdEntity().get();
        Vec3 bombPos = stand.getBtdPos();
        boolean bombExists = bombEntity != null;
        double dX1 = 0.0;
        double dY1 = 0.0;
        double dZ1 = 0.0;
        double dX2 = 0.0;
        double dY2 = 0.0;
        double dZ2 = 0.0;
        AABB bBox = null;
        if (bombEntity != null) {
            dX1 = bombEntity.m_20185_();
            dY1 = bombEntity.m_20186_();
            dZ1 = bombEntity.m_20189_();
            bBox = bombEntity.m_20191_();
            dX2 = bBox.m_82362_();
            dY2 = bBox.m_82376_();
            dZ2 = bBox.m_82385_();
        }
        if (!bombExists) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(9);
        buf.writeDouble(dX1);
        buf.writeDouble(dY1);
        buf.writeDouble(dZ1);
        buf.writeDouble(dX2);
        buf.writeDouble(dY2);
        buf.writeDouble(dZ2);
        buf.writeDouble(bombPos.f_82479_);
        buf.writeDouble(bombPos.f_82480_);
        buf.writeDouble(bombPos.f_82481_);
        boolean anyInRange = false;
        Vec3 pos = bombEntity.m_20182_();
        Vec3 v1 = pos.m_82520_(3.0, 3.0, 3.0);
        Vec3 v2 = pos.m_82520_(-3.0, -3.0, -3.0);
        List list = stand.m_9236_().m_6443_(LivingEntity.class, new AABB(v1, v2), EntitySelector.f_20403_.and(e -> e != bombEntity));
        for (LivingEntity l : list) {
            if (!(l.m_20238_(pos) < 9.0)) continue;
            anyInRange = true;
            break;
        }
        buf.writeBoolean(anyInRange);
        if (bBox.m_82309_() > 0.0) {
            ServerChannelFeedbackPacket.send(playerEntity, buf);
        }
    }

    @Override
    public MoveSelectionResult specificMoveSelectionCriterion(KQBTDEntity attacker, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        if (attacker.getBtdEntity().get() != null) {
            return MoveSelectionResult.USE;
        }
        return MoveSelectionResult.PASS;
    }

    @Override
    @NonNull
    protected BTDPlantAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BTDPlantAttack copy() {
        return this.copyExtras(new BTDPlantAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getStun(), this.getHitboxSize(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<BTDPlantAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BTDPlantAttack>, BTDPlantAttack> buildCodec(RecordCodecBuilder.Instance<BTDPlantAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.stun(), this.hitboxSize(), this.offset()).apply(instance, this.applyAttackExtras(BTDPlantAttack::new));
        }
    }
}

