/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.BubbleProjectile;
import net.arna.jcraft.common.entity.stand.KQBTDEntity;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.jetbrains.annotations.NotNull;

public final class BubbleAttack
extends AbstractMove<BubbleAttack, KQBTDEntity> {
    private WeakReference<BubbleProjectile> bubbleProjectile;

    public BubbleAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NotNull
    public MoveType<BubbleAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(KQBTDEntity attacker) {
        if (attacker.hasUser()) {
            this.tickBubble(attacker);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KQBTDEntity attacker, LivingEntity user) {
        BubbleProjectile bubbleProjectile = new BubbleProjectile(attacker.m_9236_(), user);
        bubbleProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        bubbleProjectile.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 0.5f, 0.0f);
        bubbleProjectile.m_146884_(attacker.m_20182_().m_82520_(0.0, 1.25, 0.0));
        attacker.m_9236_().m_7967_((Entity)bubbleProjectile);
        this.bubbleProjectile = new WeakReference<BubbleProjectile>(bubbleProjectile);
        JComponentPlatformUtils.getBombTracker(user).getMainBomb().setBomb((Entity)bubbleProjectile);
        return Set.of();
    }

    public void tickBubble(KQBTDEntity stand) {
        BubbleProjectile bubbleProjectile;
        BubbleProjectile bubbleProjectile2 = bubbleProjectile = this.bubbleProjectile == null ? null : (BubbleProjectile)((Object)this.bubbleProjectile.get());
        if (bubbleProjectile != null && !bubbleProjectile.isInGround() && stand.hasUser()) {
            bubbleProjectile.m_20256_(stand.getUserOrThrow().m_20154_().m_82490_(0.5));
            bubbleProjectile.f_19864_ = true;
        }
    }

    @Override
    @NonNull
    protected BubbleAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BubbleAttack copy() {
        return this.copyExtras(new BubbleAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<BubbleAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BubbleAttack>, BubbleAttack> buildCodec(RecordCodecBuilder.Instance<BubbleAttack> instance) {
            return this.baseDefault(instance, BubbleAttack::new);
        }
    }
}

