/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.killerqueen.bitesthedust;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.KQBTDEntity;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class BubbleCounterAttack
extends AbstractCounterAttack<BubbleCounterAttack, KQBTDEntity> {
    private static final CounterMissMove<KQBTDEntity> missAttack = new CounterMissMove(15);

    public BubbleCounterAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NotNull
    public MoveType<BubbleCounterAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void whiff(@NonNull KQBTDEntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.setMove(missAttack, KQBTDEntity.State.COUNTER_MISS);
        JCraft.stun(user, missAttack.getDuration(), 0);
    }

    @Override
    public void counter(@NonNull KQBTDEntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        if (countered == null || !attacker.hasUser() || counteredDamageSource.m_276093_(DamageTypes.f_268515_)) {
            return;
        }
        if (countered instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)countered;
            JCraft.stun(livingEntity, 10, 3);
            JUtils.cancelMoves(livingEntity);
        }
        JComponentPlatformUtils.getBombTracker(attacker.getUser()).getMainBomb().setBomb(countered);
    }

    @Override
    @NonNull
    protected BubbleCounterAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BubbleCounterAttack copy() {
        return this.copyExtras(new BubbleCounterAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<BubbleCounterAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BubbleCounterAttack>, BubbleCounterAttack> buildCodec(RecordCodecBuilder.Instance<BubbleCounterAttack> instance) {
            return this.baseDefault(instance, BubbleCounterAttack::new);
        }
    }
}

