/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.kingcrimson;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.BloodProjectile;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;

public final class BloodThrowAttack
extends AbstractMove<BloodThrowAttack, KingCrimsonEntity> {
    public BloodThrowAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<BloodThrowAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(KingCrimsonEntity attacker) {
        super.onInitiate(attacker);
        attacker.getUserOrThrow().m_6469_(attacker.m_9236_().m_269111_().m_269425_(), 0.1f);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KingCrimsonEntity attacker, LivingEntity user) {
        BloodProjectile bloodProjectile = new BloodProjectile(attacker.m_9236_(), user);
        bloodProjectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        bloodProjectile.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, user.m_6144_() ? 1.33f : 0.66f, 0.0f);
        bloodProjectile.m_146884_(attacker.m_146892_());
        attacker.m_9236_().m_7967_((Entity)bloodProjectile);
        return Set.of();
    }

    @Override
    @NonNull
    protected BloodThrowAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BloodThrowAttack copy() {
        return this.copyExtras(new BloodThrowAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<BloodThrowAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BloodThrowAttack>, BloodThrowAttack> buildCodec(RecordCodecBuilder.Instance<BloodThrowAttack> instance) {
            return this.baseDefault(instance, BloodThrowAttack::new);
        }
    }
}

