/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.kingcrimson;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class EpitaphAttack
extends AbstractCounterAttack<EpitaphAttack, KingCrimsonEntity> {
    private final CounterMissMove<KingCrimsonEntity> counterMiss = new CounterMissMove(20);

    public EpitaphAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<EpitaphAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void whiff(@NonNull KingCrimsonEntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.setMove(this.counterMiss, KingCrimsonEntity.State.COUNTER_MISS);
        JCraft.stun(user, this.counterMiss.getDuration(), 0);
        attacker.m_5496_((SoundEvent)JSoundRegistry.KC_RAGE.get(), 1.0f, 1.0f);
    }

    @Override
    public void counter(@NonNull KingCrimsonEntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        if (countered == null) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        Vec3 ePos = countered.m_20182_();
        if (!countered.m_5830_()) {
            Vec3 uPos = user.m_20182_();
            countered.m_20324_(uPos.f_82479_, uPos.f_82480_, uPos.f_82481_);
            user.m_20324_(ePos.f_82479_, ePos.f_82480_, ePos.f_82481_);
        }
        user.m_7618_(EntityAnchorArgument.Anchor.EYES, countered.m_146892_());
        if (countered instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)countered;
            JCraft.stun(livingEntity, 20, 0);
            JUtils.cancelMoves(livingEntity);
        }
        attacker.m_9236_().m_6263_(null, ePos.f_82479_, ePos.f_82480_, ePos.f_82481_, (SoundEvent)JSoundRegistry.TE_TP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    @NonNull
    protected EpitaphAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public EpitaphAttack copy() {
        return this.copyExtras(new EpitaphAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<EpitaphAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<EpitaphAttack>, EpitaphAttack> buildCodec(RecordCodecBuilder.Instance<EpitaphAttack> instance) {
            return this.baseDefault(instance, EpitaphAttack::new);
        }
    }
}

