/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.kingcrimson;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveClass;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class PredictionMove
extends AbstractMove<PredictionMove, KingCrimsonEntity> {
    private final Map<Entity, Vec3> predictionInfo = new WeakHashMap<Entity, Vec3>();

    public PredictionMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<PredictionMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean canBeQueued(KingCrimsonEntity attacker) {
        return false;
    }

    @Override
    public void onInitiate(KingCrimsonEntity attacker) {
        super.onInitiate(attacker);
        this.predictionInfo.clear();
        LivingEntity livingEntity = attacker.getUser();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)JPacketRegistry.S2C_EPITAPH_STATE, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer().writeBoolean(true)));
        }
    }

    @Override
    public void activeTick(KingCrimsonEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (moveStun == this.getWindupPoint()) {
            this.beginPrediction(attacker);
        }
        if (attacker.f_19797_ % 2 != 0) {
            return;
        }
        this.tickPredictions(attacker);
        if (attacker.hasUser()) {
            attacker.getUserOrThrow().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 2, true, false));
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KingCrimsonEntity attacker, LivingEntity user) {
        return Set.of();
    }

    @Override
    public boolean onInitMove(KingCrimsonEntity attacker, MoveClass moveClass) {
        if (moveClass != MoveClass.ULTIMATE || !attacker.hasUser()) {
            return false;
        }
        LivingEntity user = attacker.getUserOrThrow();
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
        if (cooldowns.getCooldown(CooldownType.STAND_ULTIMATE) <= 0) {
            cooldowns.setCooldown(CooldownType.STAND_ULTIMATE, 400);
            this.finishPrediction(attacker);
        }
        return true;
    }

    public void beginPrediction(KingCrimsonEntity attacker) {
        LivingEntity livingEntity = attacker.getUser();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        for (Entity entity : PredictionMove.getEntitiesToCatch(attacker.m_9236_(), attacker, (Player)player)) {
            this.predictionInfo.put(entity, entity.m_20182_());
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(true);
        buf.m_130130_(this.getWindupPoint());
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)JPacketRegistry.S2C_TIME_ERASE_PREDICTION_STATE, (FriendlyByteBuf)buf);
    }

    public void finishPrediction(KingCrimsonEntity attacker) {
        for (Map.Entry<Entity, Vec3> prediction : this.predictionInfo.entrySet()) {
            Entity entity = prediction.getKey();
            if (entity == null) continue;
            Vec3 pos = prediction.getValue();
            entity.m_20324_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
        PredictionMove.cancelPrediction(attacker, this.predictionInfo);
        attacker.cancelMove();
    }

    public void cancelPrediction(KingCrimsonEntity attacker) {
        PredictionMove.cancelPrediction(attacker, this.predictionInfo);
    }

    public static void cancelPrediction(KingCrimsonEntity attacker, Map<Entity, Vec3> predictionInfo) {
        LivingEntity livingEntity = attacker.getUser();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)JPacketRegistry.S2C_EPITAPH_STATE, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer().writeBoolean(false)));
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)JPacketRegistry.S2C_TIME_ERASE_PREDICTION_STATE, (FriendlyByteBuf)new FriendlyByteBuf(Unpooled.buffer().writeBoolean(false)));
        }
        predictionInfo.clear();
    }

    public void tickPredictions(KingCrimsonEntity attacker) {
        HashMap<Entity, Vec3> predictions = new HashMap<Entity, Vec3>(this.predictionInfo);
        PredictionMove.updatePredictions(predictions, attacker.getMoveStun());
        this.predictionInfo.clear();
        this.predictionInfo.putAll(predictions);
    }

    public static List<Entity> getEntitiesToCatch(Level world, StandEntity<?, ?> stand, Player player) {
        if (world == null || stand == null) {
            return Collections.emptyList();
        }
        return world.m_6443_(Entity.class, stand.m_20191_().m_82400_(64.0), EntitySelector.f_20406_.and(e -> e != stand && e != player));
    }

    public static void updatePredictions(Map<Entity, Vec3> predictions, int ticksLeft) {
        HashSet<Entity> updated = new HashSet<Entity>();
        for (Map.Entry<Entity, Vec3> prediction : predictions.entrySet()) {
            PredictionMove.updatePrediction(predictions, prediction, updated, ticksLeft);
        }
    }

    private static void updatePrediction(Map<Entity, Vec3> predictions, Map.Entry<Entity, Vec3> prediction, Set<Entity> updated, int ticksLeft) {
        Entity vehicle;
        Vec3 currentPos;
        Entity entity = prediction.getKey();
        if (updated.contains(entity)) {
            return;
        }
        updated.add(entity);
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        Level world = entity.m_9236_();
        Vec3 futurePos = currentPos = entity.m_20182_().m_82520_(0.0, 0.1, 0.0);
        boolean changed = false;
        Vec3i gravity = GravityChangerAPI.getGravityDirection(entity).m_122436_();
        Vec3 drop = new Vec3((double)gravity.m_123341_(), (double)gravity.m_123342_(), (double)gravity.m_123343_()).m_82490_(0.024525 * (double)ticksLeft * (double)ticksLeft);
        if (!(entity.m_20096_() || entity.m_5842_() || entity.m_20077_())) {
            futurePos = futurePos.m_82549_(drop);
            changed = true;
        }
        Vec3 velocity = entity.m_20184_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            velocity = JComponentPlatformUtils.getMiscData((LivingEntity)player).getDesiredVelocity();
        }
        if (velocity.m_82556_() > 1.0E-4) {
            Vec3 velocityComp = new Vec3(velocity.f_82479_ * (double)ticksLeft, Math.max(0.0, velocity.f_82480_ * (double)ticksLeft), velocity.f_82481_ * (double)ticksLeft);
            futurePos = futurePos.m_82549_(velocityComp);
            changed = true;
        }
        if ((vehicle = entity.m_20202_()) != null) {
            if (!predictions.containsKey(vehicle)) {
                return;
            }
            AbstractMap.SimpleEntry<Entity, Vec3> vehiclePrediction = new AbstractMap.SimpleEntry<Entity, Vec3>(vehicle, predictions.get(vehicle));
            PredictionMove.updatePrediction(predictions, vehiclePrediction, updated, ticksLeft);
            futurePos = futurePos.m_82549_(((Vec3)vehiclePrediction.getValue()).m_82546_(((Entity)vehiclePrediction.getKey()).m_20182_()));
        }
        if (!changed) {
            return;
        }
        BlockHitResult hitResult = world.m_45547_(new ClipContext(currentPos, futurePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, entity));
        prediction.setValue(hitResult.m_82450_());
    }

    @Override
    @NonNull
    protected PredictionMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public PredictionMove copy() {
        return this.copyExtras(new PredictionMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<PredictionMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<PredictionMove>, PredictionMove> buildCodec(RecordCodecBuilder.Instance<PredictionMove> instance) {
            return this.baseDefault(instance, PredictionMove::new);
        }
    }
}

