/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.kingcrimson;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.component.living.CommonStandComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.PlayerCloneEntity;
import net.arna.jcraft.common.entity.stand.KingCrimsonEntity;
import net.arna.jcraft.common.network.s2c.ShaderActivationPacket;
import net.arna.jcraft.common.network.s2c.ShaderDeactivationPacket;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;

public final class TimeEraseMove
extends AbstractMove<TimeEraseMove, KingCrimsonEntity> {
    private WeakReference<Mob> doppelganger;
    private final int erasureDuration;

    public TimeEraseMove(int cooldown, int windup, int duration, float moveDistance, int erasureDuration) {
        super(cooldown, windup, duration, moveDistance);
        this.erasureDuration = erasureDuration;
    }

    @Override
    @NonNull
    public MoveType<TimeEraseMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(KingCrimsonEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity livingEntity = attacker.getUser();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)JSoundRegistry.TIME_ERASE.get())), SoundSource.PLAYERS, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), 1.0f, 1.0f, 0L));
        }
    }

    @Override
    public void tick(KingCrimsonEntity attacker) {
        if (!attacker.hasUser()) {
            return;
        }
        this.tickTimeErase(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(KingCrimsonEntity attacker, LivingEntity user) {
        attacker.setTETime(this.erasureDuration);
        attacker.setCurrentMove(null);
        Object doppelganger = null;
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            ShaderActivationPacket.send(player, (Entity)attacker, 0, 120, ShaderActivationPacket.Type.CRIMSON);
            PlayerCloneEntity clone = new PlayerCloneEntity(attacker.m_9236_());
            clone.setShouldRenderForMaster(false);
            clone.disableDrops();
            clone.disableItemExchange();
            clone.setMaster((LivingEntity)player);
            doppelganger = clone;
        } else if (user instanceof Mob) {
            Mob mob = (Mob)user;
            doppelganger = JUtils.mobCloneOf(mob);
        }
        this.doppelganger = new WeakReference<Object>(doppelganger);
        if (doppelganger == null) {
            return Set.of();
        }
        doppelganger.m_20359_((Entity)user);
        doppelganger.m_5616_(user.m_6080_());
        doppelganger.m_5618_(user.m_213816_());
        doppelganger.m_8061_(EquipmentSlot.MAINHAND, user.m_21205_().m_41777_());
        doppelganger.m_8061_(EquipmentSlot.OFFHAND, user.m_21206_().m_41777_());
        doppelganger.m_8061_(EquipmentSlot.HEAD, user.m_6844_(EquipmentSlot.HEAD).m_41777_());
        doppelganger.m_8061_(EquipmentSlot.CHEST, user.m_6844_(EquipmentSlot.CHEST).m_41777_());
        doppelganger.m_8061_(EquipmentSlot.LEGS, user.m_6844_(EquipmentSlot.LEGS).m_41777_());
        doppelganger.m_8061_(EquipmentSlot.FEET, user.m_6844_(EquipmentSlot.FEET).m_41777_());
        doppelganger.m_21153_(user.m_21223_());
        doppelganger.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Short.MAX_VALUE, 9, true, false));
        this.summonFakeKC(attacker);
        doppelganger.m_6710_(user.m_21188_());
        attacker.m_9236_().m_7967_((Entity)doppelganger);
        return Set.of();
    }

    private void summonFakeKC(KingCrimsonEntity attacker) {
        Mob doppelganger = this.doppelganger == null ? null : (Mob)this.doppelganger.get();
        CommonStandComponent standData = JComponentPlatformUtils.getStandComponent((LivingEntity)doppelganger);
        standData.setTypeAndSkin(attacker.getStandType(), attacker.getSkin());
        StandEntity<?, ?> clone = JCraft.summon(attacker.m_9236_(), (LivingEntity)doppelganger);
        if (clone == null) {
            return;
        }
        clone.blocking = true;
        clone.setMoveStun(Short.MAX_VALUE);
        clone.m_20225_(true);
    }

    public void tickTimeErase(KingCrimsonEntity attacker) {
        Mob doppelganger;
        LivingEntity user = attacker.getUserOrThrow();
        int teTime = attacker.getTETime();
        if (teTime > 0) {
            attacker.setTETime(--teTime);
            if (attacker.blocking || attacker.getCurrentMove() != null && attacker.getMoveStun() < attacker.getCurrentMove().getWindupPoint() * 3 / 2) {
                this.cancelTE(attacker);
            }
            user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, 9, true, false));
            user.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 10, 0, true, false));
            user.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            AABB noBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            user.m_20011_(noBox);
            user.f_19794_ = true;
            if (teTime <= 0 && user instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)user;
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)JSoundRegistry.TIME_ERASE_EXIT.get())), SoundSource.PLAYERS, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), 1.0f, 1.0f, 0L));
            }
        }
        Mob mob = doppelganger = this.doppelganger == null ? null : (Mob)this.doppelganger.get();
        if (teTime <= 0 && doppelganger != null) {
            doppelganger.m_146870_();
        }
        attacker.m_20225_(teTime > 0);
        if (user.m_8077_()) {
            user.m_20340_(teTime <= 0);
        }
    }

    public void cancelTE(KingCrimsonEntity attacker) {
        Mob doppelganger;
        LivingEntity user = attacker.getUserOrThrow();
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
        cooldowns.setCooldown(CooldownType.STAND_ULTIMATE, cooldowns.getCooldown(CooldownType.STAND_ULTIMATE) - attacker.getTETime() * 2);
        attacker.setTETime(0);
        Mob mob = doppelganger = this.doppelganger == null ? null : (Mob)this.doppelganger.get();
        if (doppelganger != null) {
            doppelganger.m_146870_();
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ShaderDeactivationPacket.send(serverPlayer, ShaderActivationPacket.Type.CRIMSON);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)JSoundRegistry.TIME_ERASE_EXIT.get())), SoundSource.PLAYERS, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), 1.0f, 1.0f, 0L));
        }
    }

    @Override
    @NonNull
    protected TimeEraseMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public TimeEraseMove copy() {
        return this.copyExtras(new TimeEraseMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getErasureDuration()));
    }

    public WeakReference<Mob> getDoppelganger() {
        return this.doppelganger;
    }

    public int getErasureDuration() {
        return this.erasureDuration;
    }

    public static class Type
    extends AbstractMove.Type<TimeEraseMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TimeEraseMove>, TimeEraseMove> buildCodec(RecordCodecBuilder.Instance<TimeEraseMove> instance) {
            return this.baseDefault(instance).and((App)Codec.INT.fieldOf("erasure_duration").forGetter(TimeEraseMove::getErasureDuration)).apply(instance, this.applyExtras(TimeEraseMove::new));
        }
    }
}

