/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.madeinheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JParticleTypeRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class CircleAttack
extends AbstractMove<CircleAttack, MadeInHeavenEntity> {
    private int circlingTime = 0;
    private float orbitProg = 0.0f;
    private WeakReference<LivingEntity> target = new WeakReference<Object>(null);

    public CircleAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
        this.mobilityType = MobilityType.DASH;
    }

    @Override
    @NonNull
    public MoveType<CircleAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(MadeInHeavenEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUserOrThrow();
        LivingEntity target = AbstractSimpleAttack.findHits(attacker, user.m_146892_().m_82549_(attacker.m_20154_()), 2.0, null).stream().map(JUtils::getUserIfStand).findFirst().orElse(null);
        attacker.setCirclingTarget(target);
        this.target = new WeakReference<LivingEntity>(target);
        this.orbitProg = user.m_6080_();
    }

    @Override
    public void onCancel(MadeInHeavenEntity attacker) {
        this.endCircle(attacker);
    }

    @Override
    public void tick(MadeInHeavenEntity attacker) {
        super.tick(attacker);
        this.tickCircle(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MadeInHeavenEntity attacker, LivingEntity user) {
        this.circlingTime = 100;
        attacker.setAfterimage(true);
        attacker.updateRemoteInputs(0, 0, false, false);
        LivingEntity target = (LivingEntity)this.target.get();
        return target == null ? Set.of() : Set.of(target);
    }

    public void endCircle(MadeInHeavenEntity attacker) {
        this.circlingTime = 0;
        this.target = new WeakReference<Object>(null);
        attacker.setCirclingTarget(null);
        if (attacker.getAccelTime() <= 0) {
            attacker.setAfterimage(false);
        }
    }

    private void tickCircle(MadeInHeavenEntity attacker) {
        if (this.circlingTime <= 0 || !attacker.hasUser()) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        --this.circlingTime;
        LivingEntity target = (LivingEntity)this.target.get();
        if (target == null || !target.m_6084_() || target.m_213877_()) {
            this.circlingTime = 1;
        } else {
            Vec3 newVelocity;
            this.orbitProg += 0.15f;
            boolean toExit = attacker.getCurrentMove() != null && attacker.getCurrentMove() != this;
            Vec3 rotVec = user.m_20154_();
            Vec3 exitVel = Vec3.f_82478_;
            double side = attacker.getRemoteSideInput();
            double forw = attacker.getRemoteForwardInput();
            if (side != 0.0) {
                exitVel = exitVel.m_82549_(rotVec.m_82524_(1.5707963f).m_82490_(side));
                toExit = true;
            }
            if (forw != 0.0) {
                exitVel = exitVel.m_82549_(rotVec.m_82490_(forw));
                toExit = true;
            }
            if (toExit) {
                newVelocity = exitVel.m_82520_(0.0, 0.5, 0.0);
                this.endCircle(attacker);
            } else {
                Vec3 orbitPos = target.m_146892_().m_82520_(Math.sin(this.orbitProg) * 7.0, 0.0, Math.cos(this.orbitProg) * 7.0);
                Vec3 towardsVel = orbitPos.m_82546_(user.m_20182_()).m_82541_();
                double stabilization = user.m_20182_().m_82554_(orbitPos);
                if (stabilization > 0.5) {
                    stabilization = 0.5;
                }
                newVelocity = user.m_20184_().m_82490_(stabilization).m_82549_(towardsVel);
            }
            JUtils.setVelocity((Entity)user, newVelocity.f_82479_, newVelocity.f_82480_, newVelocity.f_82481_);
        }
        if (this.circlingTime == 1 || user.m_21023_((MobEffect)JStatusRegistry.DAZED.get())) {
            this.endCircle(attacker);
        }
    }

    public static void createSpeedParticles(MadeInHeavenEntity attacker, Entity entity) {
        RandomSource random = attacker.m_217043_();
        AABB box = entity.m_20191_();
        int i = 0;
        while ((double)i < box.m_82309_()) {
            entity.m_9236_().m_7106_((ParticleOptions)JParticleTypeRegistry.SPEED_PARTICLE.get(), random.m_188500_() * box.m_82362_() + box.f_82288_, random.m_188500_() * box.m_82376_() + box.f_82289_, random.m_188500_() * box.m_82385_() + box.f_82290_, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    @Override
    @NonNull
    protected CircleAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CircleAttack copy() {
        return this.copyExtras(new CircleAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<CircleAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<CircleAttack>, CircleAttack> buildCodec(RecordCodecBuilder.Instance<CircleAttack> instance) {
            return this.baseDefault(instance, CircleAttack::new);
        }
    }
}

