/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.madeinheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class FuryChopAttack
extends AbstractSimpleAttack<FuryChopAttack, MadeInHeavenEntity> {
    public FuryChopAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
        this.hitSpark = JParticleType.HIT_SPARK_2;
    }

    @Override
    @NonNull
    public MoveType<FuryChopAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MadeInHeavenEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        user.m_7292_(new MobEffectInstance(targets.isEmpty() ? MobEffects.f_19599_ : MobEffects.f_19598_, 160, 0));
        return targets;
    }

    @Override
    protected void processTarget(MadeInHeavenEntity attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 160, 0));
    }

    @Override
    @NonNull
    protected FuryChopAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public FuryChopAttack copy() {
        return this.copyExtras(new FuryChopAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<FuryChopAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FuryChopAttack>, FuryChopAttack> buildCodec(RecordCodecBuilder.Instance<FuryChopAttack> instance) {
            return this.attackDefault(instance, FuryChopAttack::new);
        }
    }
}

