/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.madeinheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.common.attack.moves.madeinheaven.SpeedSliceAttack;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public final class JudgementAttack
extends AbstractBarrageAttack<JudgementAttack, MadeInHeavenEntity> {
    private Vec3 initPos;
    private Vec3 initRot;

    public JudgementAttack(int cooldown, int windup, int duration, float moveDistance, int interval) {
        super(cooldown, windup, duration, moveDistance, 0.0f, 0, 0.0f, 0.0f, 0.0f, interval);
    }

    @Override
    @NonNull
    public MoveType<JudgementAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MadeInHeavenEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = Set.of();
        if (attacker.getMoveStun() > 1) {
            if (this.getBlow(attacker) > 0) {
                RandomSource random = attacker.m_217043_();
                targets = SpeedSliceAttack.doSpeedSlice(attacker, this.initPos.m_82549_(this.initRot.m_82490_(random.m_216328_(2.0, 2.0))), this.initPos.m_82520_(random.m_216328_(0.0, 5.0), random.m_216328_(0.0, 5.0), random.m_216328_(0.0, 5.0)), 1.0f, 0.1f, 1.75f, 20, 1);
            } else {
                this.initPos = user.m_20182_();
                this.initRot = Vec3.m_82498_((float)0.0f, (float)user.m_146908_());
            }
        } else {
            targets = SpeedSliceAttack.doSpeedSlice(attacker, this.initPos.m_82546_(user.m_20154_().m_82490_(3.0)), this.initPos.m_82549_(this.initRot.m_82490_(10.0)), 6.0f, 3.0f, 2.0f, 5, 3);
        }
        return targets;
    }

    @Override
    @NonNull
    protected JudgementAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public JudgementAttack copy() {
        return this.copyExtras(new JudgementAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getInterval()));
    }

    public static class Type
    extends AbstractBarrageAttack.Type<JudgementAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<JudgementAttack>, JudgementAttack> buildCodec(RecordCodecBuilder.Instance<JudgementAttack> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.interval()).apply(instance, this.applyAttackExtras(JudgementAttack::new));
        }
    }
}

