/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.madeinheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.AttackData;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class SpeedSliceAttack
extends AbstractMove<SpeedSliceAttack, MadeInHeavenEntity> {
    private final float damage;
    private final float hitboxSize;
    private final float knockback;

    public SpeedSliceAttack(int cooldown, int windup, int duration, float moveDistance, float damage, float hitboxSize, float knockback) {
        super(cooldown, windup, duration, moveDistance);
        this.damage = damage;
        this.hitboxSize = hitboxSize;
        this.knockback = knockback;
        this.ranged = true;
        this.mobilityType = MobilityType.TELEPORT;
    }

    @Override
    @NonNull
    public MoveType<SpeedSliceAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MadeInHeavenEntity attacker, LivingEntity user) {
        return SpeedSliceAttack.doSpeedSlice(attacker, user.m_146892_(), user.m_146892_().m_82549_(user.m_20154_().m_82490_(8.0)), this.getDamage(), this.getKnockback(), this.getHitboxSize(), 20, 1);
    }

    public static Set<LivingEntity> doSpeedSlice(MadeInHeavenEntity attacker, Vec3 start, Vec3 end, float damage, float knockback, float size, int stunTicks, int stunType) {
        Level world = attacker.m_9236_();
        LivingEntity user = attacker.getUserOrThrow();
        BlockHitResult hitResult = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user));
        Vec3 pos1 = user.m_20182_();
        Vec3 pos2 = hitResult.m_82450_();
        Vec3 towardsVec = pos2.m_82546_(pos1);
        Vec3 kbVec = towardsVec.m_82541_();
        DamageSource playerSource = world.m_269111_().m_269333_(user);
        user.m_20324_(pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
        HashSet<LivingEntity> targets = new HashSet<LivingEntity>();
        double count = Math.round(pos1.m_82554_(pos2));
        int i = 0;
        while ((double)i < count) {
            Vec3 curPos = pos1.m_82549_(towardsVec.m_82490_((double)i / count));
            Vec3 vec1 = curPos.m_82520_((double)(-size), (double)(-size), (double)(-size));
            Vec3 vec2 = curPos.m_82520_((double)size, (double)size, (double)size);
            JUtils.displayHitbox(world, vec1, vec2);
            List hurt = world.m_6443_(LivingEntity.class, new AABB(vec1, vec2), EntitySelector.f_20406_.and(e -> e != attacker && e != user));
            hurt.removeIf(targets::contains);
            targets.addAll(hurt);
            ++i;
        }
        for (LivingEntity ent : targets) {
            LivingEntity target = JUtils.getUserIfStand(ent);
            Attacks.damageLogic(world, target, new AttackData(kbVec.m_82490_((double)knockback).m_82520_(0.0, (double)(knockback / 4.0f), 0.0), stunTicks, stunType, false, damage, true, (int)(4.0f + damage), playerSource, (Entity)user, CommonHitPropertyComponent.HitAnimation.MID, attacker.getMoveUsage(), false, false));
        }
        if (attacker.getAccelTime() > 0 && !targets.isEmpty()) {
            attacker.incrementSpeedometer();
        }
        attacker.m_5496_((SoundEvent)JSoundRegistry.MIH_ZOOM.get(), 1.0f, 1.0f);
        return targets;
    }

    @Override
    @NonNull
    protected SpeedSliceAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public SpeedSliceAttack copy() {
        return this.copyExtras(new SpeedSliceAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getHitboxSize(), this.getKnockback()));
    }

    public float getDamage() {
        return this.damage;
    }

    public float getHitboxSize() {
        return this.hitboxSize;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public static class Type
    extends AbstractMove.Type<SpeedSliceAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<SpeedSliceAttack>, SpeedSliceAttack> buildCodec(RecordCodecBuilder.Instance<SpeedSliceAttack> instance) {
            return this.baseDefault(instance).and(instance.group((App)Codec.FLOAT.fieldOf("damage").forGetter(SpeedSliceAttack::getDamage), (App)Codec.FLOAT.fieldOf("hitbox_size").forGetter(SpeedSliceAttack::getHitboxSize), (App)Codec.FLOAT.fieldOf("knockback").forGetter(SpeedSliceAttack::getKnockback))).apply(instance, this.applyExtras(SpeedSliceAttack::new));
        }
    }
}

