/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.madeinheaven;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.config.IntOption;
import net.arna.jcraft.common.config.JServerConfig;
import net.arna.jcraft.common.entity.stand.MadeInHeavenEntity;
import net.arna.jcraft.common.network.s2c.TimeAccelStatePacket;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;

public final class TimeAccelerationMove
extends AbstractMove<TimeAccelerationMove, MadeInHeavenEntity> {
    private final Either<Integer, IntOption> accelerationDuration;

    public TimeAccelerationMove(int cooldown, int windup, int duration, float moveDistance, Either<Integer, IntOption> accelerationDuration) {
        super(cooldown, windup, duration, moveDistance);
        this.accelerationDuration = accelerationDuration;
    }

    @Override
    @NonNull
    public MoveType<TimeAccelerationMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(MadeInHeavenEntity attacker) {
        super.tick(attacker);
        this.tickTimeAcceleration(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MadeInHeavenEntity attacker, LivingEntity user) {
        int accelTime = (Integer)this.accelerationDuration.map(Function.identity(), IntOption::getValue);
        attacker.setAccelTime(accelTime);
        attacker.setSpeedometer(0);
        attacker.setAfterimage(true);
        TimeAccelStatePacket.sendStart(attacker, accelTime);
        return Set.of();
    }

    private void tickTimeAcceleration(MadeInHeavenEntity attacker) {
        int aTime = attacker.getAccelTime();
        attacker.setAccelTime(aTime - 1);
        if (aTime > 1) {
            List toCatch = attacker.m_9236_().m_6443_(Entity.class, attacker.m_20191_().m_82400_(96.0), EntitySelector.f_20406_);
            for (Entity entity : toCatch) {
                if (entity instanceof LivingEntity) continue;
                entity.m_8119_();
            }
        } else if (aTime == 1) {
            if (attacker.getSpeedometer() == 30) {
                List toCatch = attacker.m_9236_().m_6443_(LivingEntity.class, attacker.m_20191_().m_82400_(96.0), EntitySelector.f_20406_.and(e -> e != attacker && e != attacker.getUser()));
                for (LivingEntity entity : toCatch) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.STANDLESS.get(), 300, 0, true, false));
                }
            }
            attacker.setAfterimage(false);
            attacker.setSpeedometer(0);
        }
    }

    @Override
    @NonNull
    protected TimeAccelerationMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public TimeAccelerationMove copy() {
        return this.copyExtras(new TimeAccelerationMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getAccelerationDuration()));
    }

    public Either<Integer, IntOption> getAccelerationDuration() {
        return this.accelerationDuration;
    }

    public static class Type
    extends AbstractMove.Type<TimeAccelerationMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<TimeAccelerationMove>, TimeAccelerationMove> buildCodec(RecordCodecBuilder.Instance<TimeAccelerationMove> instance) {
            return this.baseDefault(instance).and((App)Codec.either((Codec)ExtraCodecs.f_144629_, JServerConfig.INT_OPTION_CODEC).fieldOf("acceleration_duration").forGetter(TimeAccelerationMove::getAccelerationDuration)).apply(instance, this.applyExtras(TimeAccelerationMove::new));
        }
    }
}

