/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.magiciansred;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.AnkhProjectile;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class CrossfireAttack
extends AbstractMove<CrossfireAttack, MagiciansRedEntity> {
    public CrossfireAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<CrossfireAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MagiciansRedEntity attacker, LivingEntity user) {
        for (int i = 0; i < 3; ++i) {
            AnkhProjectile ankh = new AnkhProjectile(attacker.m_9236_(), user);
            ankh.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.0f, 5.0f);
            ankh.m_146884_(this.getOffsetHeightPos(attacker));
            attacker.m_9236_().m_7967_((Entity)ankh);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected CrossfireAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CrossfireAttack copy() {
        return this.copyExtras(new CrossfireAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<CrossfireAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<CrossfireAttack>, CrossfireAttack> buildCodec(RecordCodecBuilder.Instance<CrossfireAttack> instance) {
            return this.baseDefault(instance, CrossfireAttack::new);
        }
    }
}

