/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.magiciansred;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.damage.JDamageSources;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.arna.jcraft.common.network.s2c.ServerChannelFeedbackPacket;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class CrossfireHurricaneAttack
extends AbstractMove<CrossfireHurricaneAttack, MagiciansRedEntity> {
    private int hurricaneTime = 0;
    private Vec3 hurricanePos = Vec3.f_82478_;

    public CrossfireHurricaneAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<CrossfireHurricaneAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(MagiciansRedEntity attacker) {
        this.tickHurricane(attacker);
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MagiciansRedEntity attacker, LivingEntity user) {
        this.hurricaneTime = 50;
        this.hurricanePos = attacker.m_20182_();
        return Set.of();
    }

    public void tickHurricane(MagiciansRedEntity stand) {
        LivingEntity user = stand.getUserOrThrow();
        Entity vehicle = user.m_20202_();
        Level world = stand.m_9236_();
        if (stand.f_19797_ % 4 != 0 || this.hurricaneTime <= 0) {
            return;
        }
        --this.hurricaneTime;
        List nearbyEnts = world.m_6443_(LivingEntity.class, new AABB(this.hurricanePos.m_82520_(32.0, 32.0, 32.0), this.hurricanePos.m_82492_(32.0, 32.0, 32.0)), EntitySelector.f_20406_.and(e -> e != vehicle && e != stand && e != user));
        if (!nearbyEnts.isEmpty()) {
            Vec3 avgPos = Vec3.f_82478_;
            for (LivingEntity livingEntity : nearbyEnts) {
                avgPos = avgPos.m_82549_(livingEntity.m_146892_());
            }
            avgPos = avgPos.m_82490_(1.0 / (double)nearbyEnts.size());
            this.hurricanePos = this.hurricanePos.m_82549_(avgPos.m_82546_(this.hurricanePos).m_82541_().m_82490_(0.5));
        }
        List toHurt = world.m_6443_(LivingEntity.class, new AABB(this.hurricanePos.m_82520_(2.5, 1.0, 2.5), this.hurricanePos.m_82492_(2.5, 1.0, 2.5)), EntitySelector.f_20406_.and(e -> e != stand && e != user && e != vehicle));
        for (LivingEntity living : toHurt) {
            LivingEntity target = JUtils.getUserIfStand(living);
            if (this.hurricaneTime > 1) {
                Attacks.damageLogic(world, target, new Vec3(Math.sin((double)stand.f_19797_ / 10.0) * 3.0, 0.0, Math.cos((double)stand.f_19797_ / 10.0) * 3.0), 10, 1, false, 0.5f, true, 5, JDamageSources.stand(stand), (Entity)user, CommonHitPropertyComponent.HitAnimation.MID);
                if (this.hurricaneTime <= 15) continue;
                this.hurricaneTime = 15;
                continue;
            }
            target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 20, 0));
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeShort(10);
        buf.writeDouble(this.hurricanePos.f_82479_);
        buf.writeDouble(this.hurricanePos.f_82480_);
        buf.writeDouble(this.hurricanePos.f_82481_);
        ServerChannelFeedbackPacket.send(JUtils.around((ServerLevel)world, this.hurricanePos, 128.0), buf);
    }

    @Override
    @NonNull
    protected CrossfireHurricaneAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CrossfireHurricaneAttack copy() {
        return this.copyExtras(new CrossfireHurricaneAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<CrossfireHurricaneAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<CrossfireHurricaneAttack>, CrossfireHurricaneAttack> buildCodec(RecordCodecBuilder.Instance<CrossfireHurricaneAttack> instance) {
            return this.baseDefault(instance, CrossfireHurricaneAttack::new);
        }
    }
}

