/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.magiciansred;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.AnkhProjectile;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class CrossfireVariationAttack
extends AbstractMove<CrossfireVariationAttack, MagiciansRedEntity> {
    private static final int variationAnkhs = 6;

    public CrossfireVariationAttack(int cooldown, int windup, int moveStunTicks, float moveDistance) {
        super(cooldown, windup, moveStunTicks, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<CrossfireVariationAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MagiciansRedEntity attacker, LivingEntity user) {
        int orbitRange = user.m_6144_() ? 7 : 5;
        for (int i = 0; i < 6; ++i) {
            AnkhProjectile ankh = new AnkhProjectile(attacker.m_9236_(), user);
            ankh.m_20334_(0.0, 1.0, 0.0);
            ankh.m_146884_(this.getOffsetHeightPos(attacker).m_82520_(0.0, 1.0, 0.0));
            ankh.setVariation(true);
            ankh.setOrbitRange(orbitRange);
            ankh.setOrbitOffset(60.0f * (float)i);
            attacker.m_9236_().m_7967_((Entity)ankh);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected CrossfireVariationAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public CrossfireVariationAttack copy() {
        return this.copyExtras(new CrossfireVariationAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<CrossfireVariationAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<CrossfireVariationAttack>, CrossfireVariationAttack> buildCodec(RecordCodecBuilder.Instance<CrossfireVariationAttack> instance) {
            return this.baseDefault(instance, CrossfireVariationAttack::new);
        }
    }
}

