/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.magiciansred;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.projectile.RedBindEntity;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class RedBindAttack
extends AbstractSimpleAttack<RedBindAttack, MagiciansRedEntity> {
    public RedBindAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset);
    }

    @Override
    @NonNull
    public MoveType<RedBindAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MagiciansRedEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        if (targets.isEmpty()) {
            return targets;
        }
        LivingEntity boundEntity = JUtils.getUserIfStand((LivingEntity)targets.stream().findFirst().orElseThrow());
        if (JUtils.isBlocking(boundEntity)) {
            return Set.of();
        }
        StandEntity<?, ?> boundStand = JUtils.getStand(boundEntity);
        if (boundStand != null) {
            boundStand.setCurrentMove((AbstractMove<?, ?>)null);
            boundStand.setMoveStun(0);
            boundStand.desummon();
        }
        boundEntity.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
        JCraft.stun(boundEntity, 60, 0, (Entity)user);
        RedBindEntity redBind = new RedBindEntity(attacker.m_9236_());
        redBind.m_146884_(boundEntity.m_20182_());
        redBind.setMaster(user);
        redBind.setBoundEntity(boundEntity);
        attacker.m_9236_().m_7967_((Entity)redBind);
        return targets;
    }

    @Override
    @NonNull
    protected RedBindAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public RedBindAttack copy() {
        return this.copyExtras(new RedBindAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset()));
    }

    public static class Type
    extends AbstractSimpleAttack.Type<RedBindAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<RedBindAttack>, RedBindAttack> buildCodec(RecordCodecBuilder.Instance<RedBindAttack> instance) {
            return this.attackDefault(instance, RedBindAttack::new);
        }
    }
}

