/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.magiciansred;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MobilityType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.projectile.AnkhProjectile;
import net.arna.jcraft.common.entity.stand.MagiciansRedEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;

public final class RedirectAttack
extends AbstractMove<RedirectAttack, MagiciansRedEntity> {
    public RedirectAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.mobilityType = MobilityType.TELEPORT;
    }

    @Override
    @NonNull
    public MoveType<RedirectAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MagiciansRedEntity attacker, LivingEntity user) {
        List ankhs = attacker.m_9236_().m_6443_(AnkhProjectile.class, attacker.m_20191_().m_82400_(32.0), EntitySelector.f_20402_);
        Vec3 eyePos = this.getOffsetHeightPos(attacker);
        if (!ankhs.isEmpty()) {
            Vec3 pos = JUtils.raycastAll((Entity)user, eyePos, eyePos.m_82549_(user.m_20154_().m_82490_(24.0)), ClipContext.Fluid.NONE).m_82450_();
            for (AnkhProjectile ankh : ankhs) {
                if (ankh.m_19749_() != user) continue;
                ankh.setVariation(false);
                ankh.m_20256_(pos.m_82546_(ankh.m_20182_()).m_82541_().m_82490_(0.6));
                ankh.f_19864_ = true;
            }
        }
        return Set.of();
    }

    @Override
    public MoveSelectionResult specificMoveSelectionCriterion(MagiciansRedEntity attacker, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        return (double)attacker.m_217043_().m_188501_() > 0.05 ? MoveSelectionResult.STOP : MoveSelectionResult.PASS;
    }

    @Override
    @NonNull
    protected RedirectAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public RedirectAttack copy() {
        return this.copyExtras(new RedirectAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<RedirectAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<RedirectAttack>, RedirectAttack> buildCodec(RecordCodecBuilder.Instance<RedirectAttack> instance) {
            return this.baseDefault(instance, RedirectAttack::new);
        }
    }
}

