/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.mandom;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.arna.jcraft.api.JRegistries;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.attack.moves.BlockMarkerMove;
import net.arna.jcraft.api.component.living.CommonCooldownsComponent;
import net.arna.jcraft.api.registry.JPacketRegistry;
import net.arna.jcraft.common.entity.stand.MandomEntity;
import net.arna.jcraft.common.marker.BlockMarker;
import net.arna.jcraft.common.marker.BlockMarkerMoves;
import net.arna.jcraft.common.marker.BlockMarkerType;
import net.arna.jcraft.common.marker.EntityDataHandler;
import net.arna.jcraft.common.marker.EntityMarker;
import net.arna.jcraft.common.marker.EntityMarkerType;
import net.arna.jcraft.common.marker.Identifiers;
import net.arna.jcraft.common.marker.Predicates;
import net.arna.jcraft.common.util.CooldownType;
import net.arna.jcraft.common.util.TriConsumer;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class CountdownMove
extends AbstractMove<CountdownMove, MandomEntity>
implements BlockMarkerMove {
    private static final int COUNTDOWN_COOLDOWN_TICKS = 120;
    public static final Set<ResourceLocation> ENTITY_STUFF_TO_SAVE = Set.of(Identifiers.POSITION, Identifiers.YAW, Identifiers.YAW_HEAD, Identifiers.PITCH, Identifiers.VELOCITY, Identifiers.FOOD_DATA, Identifiers.BLOOD_GAUGE, Identifiers.HEALTH, Identifiers.ACTIVE_EFFECTS, Identifiers.VEHICLE);
    static final BlockMarkerType BLOCK_MARKER_TYPE = new BlockMarkerType((pos, state) -> false, (marker, level) -> true);
    private final int radius;
    private final int maxCountdownTicks;
    private final List<EntityMarker> timeEntityMarkers = new LinkedList<EntityMarker>();
    private final List<BlockMarker> timeBlockMarkers = new ArrayList<BlockMarker>();
    private boolean resolving;
    private final EntityMarkerType entityMarkerType;
    private final List<RewindData> rewindInfo = new ArrayList<RewindData>();
    private boolean countdownActive = false;
    private int countdownTicks;
    private BlockPos attackerBlockPos;

    public CountdownMove(int cooldown, int windup, int duration, float moveDistance, int radius, int maxCountdownTicks, @NonNull Set<ResourceLocation> rewindIds, @NonNull TriConsumer<ResourceLocation, Entity, CompoundTag> extractor, @NonNull TriConsumer<ResourceLocation, Entity, CompoundTag> injector) {
        super(cooldown, windup, duration, moveDistance);
        if (rewindIds == null) {
            throw new NullPointerException("rewindIds is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        if (injector == null) {
            throw new NullPointerException("injector is marked non-null but is null");
        }
        if (radius < 0) {
            throw new IllegalArgumentException("radius cannot be negative!");
        }
        this.radius = radius;
        if (maxCountdownTicks < 0) {
            throw new IllegalArgumentException("maxCountdownTicks cannot be negative!");
        }
        this.maxCountdownTicks = maxCountdownTicks;
        this.entityMarkerType = new EntityMarkerType(entity -> true, Predicates.DEFAULT_LOAD, rewindIds, new EntityDataHandler(Predicates.fromSet(rewindIds), extractor, injector));
    }

    @Override
    @NotNull
    public MoveType<CountdownMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(MandomEntity attacker) {
        super.tick(attacker);
        if (++this.countdownTicks > this.maxCountdownTicks) {
            this.countdownActive = false;
        }
        if (!this.countdownActive) {
            this.countdownTicks = 0;
            return;
        }
        this.tickCountdownInfo(attacker);
    }

    @Override
    public boolean addBlock(@NonNull BlockPos pos, @NonNull BlockState state) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (!this.countdownActive) {
            return false;
        }
        if (pos.m_123331_((Vec3i)this.attackerBlockPos) > (double)(this.radius * this.radius)) {
            return false;
        }
        if (this.resolving || !BLOCK_MARKER_TYPE.shouldSave(pos, state)) {
            return false;
        }
        for (BlockMarker timeBlockMarker : this.timeBlockMarkers) {
            if (!timeBlockMarker.pos().equals((Object)pos)) continue;
            return false;
        }
        this.timeBlockMarkers.add(BLOCK_MARKER_TYPE.save(pos, state));
        return true;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MandomEntity attacker, LivingEntity user) {
        Object player;
        BlockMarkerMoves.add(attacker, this);
        List toCapture = attacker.m_9236_().m_6443_(Entity.class, attacker.m_20191_().m_82400_((double)this.radius), EntitySelector.f_20406_.and(e -> e != attacker));
        if (!(user instanceof Player) || !(player = (Player)user).m_7500_() && !player.m_5833_()) {
            toCapture.add(user);
        }
        this.timeEntityMarkers.clear();
        this.timeBlockMarkers.clear();
        this.rewindInfo.clear();
        this.attackerBlockPos = attacker.m_20183_();
        for (Entity entity : toCapture) {
            if (!this.entityMarkerType.shouldSave(entity.m_20148_(), entity)) continue;
            this.timeEntityMarkers.add(this.entityMarkerType.save(entity.m_20148_(), entity));
            this.rewindInfo.add(new RewindData(entity.m_146892_(), entity));
        }
        this.countdownActive = true;
        this.countdownTicks = 0;
        this.resolving = false;
        CommonCooldownsComponent cooldowns = JComponentPlatformUtils.getCooldowns(user);
        cooldowns.setCooldown(CooldownType.UTILITY, 120);
        cooldowns.setCooldown(CooldownType.STAND_ULTIMATE, 120);
        return Set.of();
    }

    public void tickCountdownInfo(MandomEntity attacker) {
        LivingEntity livingEntity = attacker.getUser();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        if (this.rewindInfo.isEmpty()) {
            return;
        }
        for (RewindData data : this.rewindInfo) {
            Entity entity = data.entity();
            if (entity == null || !entity.m_6084_()) continue;
            Vec3 position = data.originalPos();
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(entity.m_19879_());
            buf.writeDouble(position.m_7096_());
            buf.writeDouble(position.m_7098_());
            buf.writeDouble(position.m_7094_());
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)JPacketRegistry.S2C_MANDOM_DATA, (FriendlyByteBuf)buf);
        }
    }

    @Override
    @NonNull
    protected CountdownMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public CountdownMove copy() {
        return this.copyExtras(new CountdownMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getRadius(), this.getMaxCountdownTicks(), this.entityMarkerType.getIds(), this.entityMarkerType.getDataHandler().extractor(), this.entityMarkerType.getDataHandler().injector()));
    }

    public int getRadius() {
        return this.radius;
    }

    public int getMaxCountdownTicks() {
        return this.maxCountdownTicks;
    }

    public List<EntityMarker> getTimeEntityMarkers() {
        return this.timeEntityMarkers;
    }

    public List<BlockMarker> getTimeBlockMarkers() {
        return this.timeBlockMarkers;
    }

    @Override
    public boolean isResolving() {
        return this.resolving;
    }

    @Override
    public void setResolving(boolean resolving) {
        this.resolving = resolving;
    }

    public EntityMarkerType getEntityMarkerType() {
        return this.entityMarkerType;
    }

    public List<RewindData> getRewindInfo() {
        return this.rewindInfo;
    }

    public boolean isCountdownActive() {
        return this.countdownActive;
    }

    public void setCountdownActive(boolean countdownActive) {
        this.countdownActive = countdownActive;
    }

    public int getCountdownTicks() {
        return this.countdownTicks;
    }

    public static class Type
    extends AbstractMove.Type<CountdownMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<CountdownMove>, CountdownMove> buildCodec(RecordCodecBuilder.Instance<CountdownMove> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), (App)ExtraCodecs.f_144628_.fieldOf("radius").forGetter(CountdownMove::getRadius), (App)ExtraCodecs.f_144628_.fieldOf("maxCountdownTicks").forGetter(CountdownMove::getMaxCountdownTicks), (App)ResourceLocation.f_135803_.listOf().xmap(list -> list.stream().collect(Collectors.toSet()), set -> set.stream().toList()).fieldOf("rewindIds").forGetter(move -> move.getEntityMarkerType().getIds()), (App)JRegistries.EXTRACTOR_CODEC.fieldOf("extractor").forGetter(move -> move.getEntityMarkerType().getDataHandler().extractor()), (App)JRegistries.INJECTOR_CODEC.fieldOf("injector").forGetter(move -> move.getEntityMarkerType().getDataHandler().injector())).apply(instance, this.applyExtras(CountdownMove::new));
        }
    }

    public record RewindData(Vec3 originalPos, Entity entity) {
    }
}

