/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.mandom;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.moves.mandom.CountdownMove;
import net.arna.jcraft.common.entity.stand.MandomEntity;
import net.arna.jcraft.common.marker.BlockMarker;
import net.arna.jcraft.common.marker.EntityMarker;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public final class RewindMove
extends AbstractMove<RewindMove, MandomEntity> {
    private final int reach;

    public RewindMove(int cooldown, int windup, int duration, float moveDistance, int reach) {
        super(cooldown, windup, duration, moveDistance);
        if (reach < 0) {
            throw new IllegalArgumentException("Rewind teleport reach cannot be negative!");
        }
        this.reach = reach;
    }

    @Override
    @NotNull
    public MoveType<RewindMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MandomEntity attacker, LivingEntity user) {
        CountdownMove countdownMove = attacker.getMove(CountdownMove.class);
        if (countdownMove == null || !countdownMove.isCountdownActive()) {
            return Set.of();
        }
        ServerLevel level = (ServerLevel)attacker.m_9236_();
        List<BlockMarker> blockMarkers = countdownMove.getTimeBlockMarkers();
        countdownMove.setResolving(true);
        for (BlockMarker marker : blockMarkers) {
            if (!CountdownMove.BLOCK_MARKER_TYPE.shouldLoad(marker, level)) continue;
            CountdownMove.BLOCK_MARKER_TYPE.load(marker, level);
        }
        List<EntityMarker> entityMarkers = countdownMove.getTimeEntityMarkers();
        for (EntityMarker marker : entityMarkers) {
            if (!countdownMove.getEntityMarkerType().shouldLoad(marker, level)) continue;
            countdownMove.getEntityMarkerType().load(marker, level);
        }
        entityMarkers.clear();
        blockMarkers.clear();
        countdownMove.getRewindInfo().clear();
        countdownMove.setCountdownActive(false);
        return Set.of();
    }

    @Override
    @NonNull
    protected RewindMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public RewindMove copy() {
        return this.copyExtras(new RewindMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), 200));
    }

    public int getReach() {
        return this.reach;
    }

    public static final class Type
    extends AbstractMove.Type<RewindMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NotNull
        protected App<RecordCodecBuilder.Mu<RewindMove>, RewindMove> buildCodec(RecordCodecBuilder.Instance<RewindMove> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), (App)ExtraCodecs.f_144628_.fieldOf("reach").forGetter(RewindMove::getReach)).apply(instance, this.applyExtras(RewindMove::new));
        }
    }
}

