/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.BisectProjectile;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BisectAttack
extends AbstractMove<BisectAttack, MetallicaEntity> {
    public BisectAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<BisectAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        BisectProjectile bisect = new BisectProjectile(attacker.m_9236_(), user);
        bisect.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 2.0f, 0.0f);
        bisect.setScale((float)attacker.getBisectChargeTime() / 10.0f);
        attacker.m_9236_().m_7967_((Entity)bisect);
        return Set.of();
    }

    @Override
    @NonNull
    protected BisectAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BisectAttack copy() {
        return this.copyExtras(new BisectAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<BisectAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BisectAttack>, BisectAttack> buildCodec(RecordCodecBuilder.Instance<BisectAttack> instance) {
            return this.baseDefault(instance, BisectAttack::new);
        }
    }
}

