/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractHoldableMove;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.minecraft.world.entity.LivingEntity;

public class BisectChargeMove
extends AbstractHoldableMove<BisectChargeMove, MetallicaEntity> {
    public BisectChargeMove(int cooldown, int windup, int duration, float moveDistance, int minimumCharge) {
        super(cooldown, windup, duration, moveDistance, minimumCharge);
    }

    @Override
    @NonNull
    public MoveType<BisectChargeMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public boolean conditionsMet(MetallicaEntity attacker) {
        return super.conditionsMet(attacker) && (attacker.getIron() >= 24.0f || attacker.getBisectChargeTime() > 0);
    }

    @Override
    public void onInitiate(MetallicaEntity attacker) {
        super.onInitiate(attacker);
        attacker.setBisectChargeTime(0);
    }

    @Override
    public void activeTick(MetallicaEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        if (attacker.drainIron(2.0f)) {
            attacker.setBisectChargeTime(attacker.getBisectChargeTime() + 1);
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        return Set.of();
    }

    @Override
    @NonNull
    protected BisectChargeMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public BisectChargeMove copy() {
        return this.copyExtras(new BisectChargeMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getMinimumCharge()));
    }

    public static class Type
    extends AbstractHoldableMove.Type<BisectChargeMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BisectChargeMove>, BisectChargeMove> buildCodec(RecordCodecBuilder.Instance<BisectChargeMove> instance) {
            return this.holdableDefault(instance, BisectChargeMove::new);
        }
    }
}

