/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.ScalpelProjectile;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class FanTossAttack
extends AbstractMove<FanTossAttack, MetallicaEntity> {
    public FanTossAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<FanTossAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        float offset = 10.0f;
        int index = 0;
        for (int i = 0; i < 5; ++i) {
            ScalpelProjectile scalpel = ScalpelProjectile.fromMetallica(attacker);
            if (scalpel == null) continue;
            index = i % 2 == 0 ? (index -= i) : (index += i);
            float pitch = user.m_146909_();
            float yaw = user.m_146908_() + (float)index * 10.0f;
            Vec3 rotVec = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(yaw, pitch), GravityChangerAPI.getGravityDirection((Entity)user));
            scalpel.m_6686_(rotVec.f_82479_, rotVec.f_82480_, rotVec.f_82481_, 1.75f, 0.1f);
            Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)attacker.getUserOrThrow());
            Vec3 heightOffset = upVec.m_82490_(0.75);
            scalpel.m_146884_(attacker.getBaseEntity().m_20182_().m_82549_(heightOffset));
            attacker.m_9236_().m_7967_((Entity)scalpel);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected FanTossAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public FanTossAttack copy() {
        return this.copyExtras(new FanTossAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<FanTossAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FanTossAttack>, FanTossAttack> buildCodec(RecordCodecBuilder.Instance<FanTossAttack> instance) {
            return this.baseDefault(instance, FanTossAttack::new);
        }
    }
}

