/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.MoveSelectionResult;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.MoveInputType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JTagRegistry;
import net.arna.jcraft.api.stand.StandEntity;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class HarvestMove
extends AbstractBarrageAttack<HarvestMove, MetallicaEntity> {
    public HarvestMove(int duration, float moveDistance, int interval) {
        super(0, 0, duration, moveDistance, 0.0f, 0, 0.0f, 0.0f, 0.0f, interval);
        this.withHoldable();
    }

    @Override
    @NonNull
    public MoveType<HarvestMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(MetallicaEntity attacker) {
        super.onInitiate(attacker);
        attacker.m_20088_().m_135381_(MetallicaEntity.SIPHON_POS, Optional.empty());
    }

    @Override
    public void onUserMoveInput(MetallicaEntity attacker, MoveInputType type, boolean pressed, boolean moveInitiated) {
        super.onUserMoveInput(attacker, type, pressed, moveInitiated);
        if (type.getMoveClass() == this.getMoveClass() && !pressed) {
            attacker.cancelMove();
        }
    }

    @Override
    public void activeTick(MetallicaEntity attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        LivingEntity user = attacker.getUser();
        if (user instanceof Player) {
            return;
        }
        if (attacker.getIron() >= 80.0f) {
            attacker.cancelMove();
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        BlockHitResult hitResult = JUtils.genericBlockRaycast(user.m_9236_(), (Entity)user, 5.0, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            float gain;
            BlockPos hitPos = hitResult.m_82425_();
            attacker.m_20088_().m_135381_(MetallicaEntity.SIPHON_POS, Optional.of(hitPos));
            float f = gain = user.m_9236_().m_8055_(hitPos).m_204336_(JTagRegistry.IRON_BLOCKS) ? 3.0f : 1.5f;
            if (((Boolean)attacker.m_20088_().m_135370_(MetallicaEntity.INVISIBLE)).booleanValue()) {
                gain /= 2.0f;
            }
            attacker.addIron(gain);
        } else {
            attacker.m_20088_().m_135381_(MetallicaEntity.SIPHON_POS, Optional.empty());
        }
        return targets;
    }

    @Override
    public MoveSelectionResult specificMoveSelectionCriterion(MetallicaEntity attacker, LivingEntity mob, LivingEntity target, int stunTicks, int enemyMoveStun, double distance, StandEntity<?, ?> enemyStand, AbstractMove<?, ?> enemyAttack) {
        return attacker.getIron() >= 80.0f ? MoveSelectionResult.STOP : MoveSelectionResult.PASS;
    }

    @Override
    @NonNull
    protected HarvestMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public HarvestMove copy() {
        return this.copyExtras(new HarvestMove(this.getDuration(), this.getMoveDistance(), this.getInterval()));
    }

    public static class Type
    extends AbstractBarrageAttack.Type<HarvestMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<HarvestMove>, HarvestMove> buildCodec(RecordCodecBuilder.Instance<HarvestMove> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.duration(), this.moveDistance(), this.interval()).apply(instance, this.applyAttackExtras(HarvestMove::new));
        }
    }
}

