/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.projectile.RazorProjectile;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class InternalAttack
extends AbstractMove<InternalAttack, MetallicaEntity> {
    private static final int RAZOR_VOMIT_DURATION = 20;
    private WeakReference<LivingEntity> razorTarget;
    private int razorTime;

    public InternalAttack(int cooldown, int windup, int duration) {
        super(cooldown, windup, duration, 0.0f);
        this.manualCooldown = true;
    }

    @Override
    @NonNull
    public MoveType<InternalAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void tick(MetallicaEntity attacker) {
        LivingEntity target;
        LivingEntity livingEntity = target = this.razorTarget == null ? null : (LivingEntity)this.razorTarget.get();
        if (this.razorTime > 0 && target != null && target.m_6084_()) {
            if (this.razorTime % 2 == 0) {
                RazorProjectile razor = new RazorProjectile(attacker.m_9236_(), attacker.getUserOrThrow());
                razor.m_146884_(target.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)target)));
                JUtils.shoot((Projectile)razor, (Entity)attacker.getUserOrThrow(), target.m_146909_(), target.m_146908_(), target.m_217043_().m_188501_() - 0.5f, 0.5f, 30.0f);
                attacker.m_9236_().m_7967_((Entity)razor);
            }
            --this.razorTime;
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        EntityHitResult entityHitResult;
        Entity entity;
        Vec3 rotVec;
        Vec3 eyePos = user.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)user));
        HitResult hitResult = JUtils.raycastAll((Entity)user, eyePos, eyePos.m_82549_((rotVec = user.m_20154_()).m_82490_(12.0)), ClipContext.Fluid.NONE, EntitySelector.f_20403_);
        if (hitResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity target = JUtils.getUserIfStand(living);
            if (target.m_21023_((MobEffect)JStatusRegistry.HYPOXIA.get())) {
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)user;
                    serverPlayer.m_5661_((Component)Component.m_237113_((String)"Cannot attack hypoxic targets."), true);
                }
            } else {
                ServerLevel serverWorld = (ServerLevel)user.m_9236_();
                double x = target.m_20185_();
                double y = target.m_20186_();
                double z = target.m_20189_();
                RandomSource random = attacker.m_217043_();
                for (int i = 0; i < 3; ++i) {
                    JCraft.createParticle(serverWorld, x + random.m_188583_(), y + random.m_188583_(), z + random.m_188583_(), JParticleType.SWEEP_ATTACK);
                }
                Attacks.damage((Entity)attacker, 3.5f, serverWorld.m_269111_().m_269396_(user), target);
                target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.HYPOXIA.get(), 60, 0, false, true));
                JComponentPlatformUtils.getCooldowns(user).setCooldown(this.getMoveClass().getDefaultCooldownType(), this.getCooldown());
                this.razorTarget = new WeakReference<LivingEntity>(target);
                this.razorTime = 20;
            }
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected InternalAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public InternalAttack copy() {
        return this.copyExtras(new InternalAttack(this.getCooldown(), this.getWindup(), this.getDuration()));
    }

    public static class Type
    extends AbstractMove.Type<InternalAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<InternalAttack>, InternalAttack> buildCodec(RecordCodecBuilder.Instance<InternalAttack> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration()).apply(instance, this.applyExtras(InternalAttack::new));
        }
    }
}

