/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.WeakReference;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.tickable.MagneticFields;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class InvisibilityMove
extends AbstractMove<InvisibilityMove, MetallicaEntity> {
    private WeakReference<MagneticFields.MagneticField> magneticField;

    public InvisibilityMove(int cooldown, int windup, int duration) {
        super(cooldown, windup, duration, 0.0f);
    }

    @Override
    @NonNull
    public MoveType<InvisibilityMove> getMoveType() {
        return Type.INSTANCE;
    }

    private void setInvisible(MetallicaEntity metallica, boolean invis) {
        metallica.m_20088_().m_135381_(MetallicaEntity.INVISIBLE, (Object)invis);
        if (invis) {
            LivingEntity user = metallica.getUserOrThrow();
            user.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 39, 0, true, false));
            this.magneticField = new WeakReference<MagneticFields.MagneticField>(MagneticFields.createField((ServerLevel)metallica.m_9236_(), null, metallica.m_20182_(), 3.0f, 5.0f));
        } else {
            MagneticFields.MagneticField field;
            MagneticFields.MagneticField magneticField = field = this.magneticField == null ? null : (MagneticFields.MagneticField)this.magneticField.get();
            if (field == null) {
                JCraft.LOGGER.warn("Metallica InvisibilityMove#MAGNETIC_FIELD was null when decloaking!");
            } else {
                field.time = 0;
            }
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        boolean newInvis = (Boolean)attacker.m_20088_().m_135370_(MetallicaEntity.INVISIBLE) == false;
        this.setInvisible(attacker, newInvis);
        return Set.of();
    }

    @Override
    public void tick(MetallicaEntity attacker) {
        super.tick(attacker);
        boolean invisible = (Boolean)attacker.m_20088_().m_135370_(MetallicaEntity.INVISIBLE);
        if (!invisible || attacker.f_19797_ % 2 != 0) {
            return;
        }
        boolean canStayInvis = attacker.drainIron(0.75f);
        if (!canStayInvis) {
            this.setInvisible(attacker, false);
        } else {
            MagneticFields.MagneticField field;
            LivingEntity user = attacker.getUserOrThrow();
            MagneticFields.MagneticField magneticField = field = this.magneticField == null ? null : (MagneticFields.MagneticField)this.magneticField.get();
            if (field != null) {
                field.pos = attacker.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)user));
            }
            user.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 21, 0, true, false));
        }
    }

    @Override
    @NonNull
    protected InvisibilityMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public InvisibilityMove copy() {
        return this.copyExtras(new InvisibilityMove(this.getCooldown(), this.getWindup(), this.getDuration()));
    }

    public static class Type
    extends AbstractMove.Type<InvisibilityMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<InvisibilityMove>, InvisibilityMove> buildCodec(RecordCodecBuilder.Instance<InvisibilityMove> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration()).apply(instance, this.applyExtras(InvisibilityMove::new));
        }
    }
}

