/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.ScalpelProjectile;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class PreciseTossAttack
extends AbstractMove<PreciseTossAttack, MetallicaEntity> {
    public PreciseTossAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<PreciseTossAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        Vec3 pos = attacker.m_20182_();
        Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)user);
        for (int i = 1; i < 4; ++i) {
            ScalpelProjectile scalpel = ScalpelProjectile.fromMetallica(attacker);
            if (scalpel == null) continue;
            scalpel.m_146884_(pos.m_82549_(upVec.m_82490_(0.25 * (double)i)));
            scalpel.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.25f, 0.0f);
            attacker.m_9236_().m_7967_((Entity)scalpel);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected PreciseTossAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public PreciseTossAttack copy() {
        return this.copyExtras(new PreciseTossAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<PreciseTossAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<PreciseTossAttack>, PreciseTossAttack> buildCodec(RecordCodecBuilder.Instance<PreciseTossAttack> instance) {
            return this.baseDefault(instance, PreciseTossAttack::new);
        }
    }
}

