/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.tickable.MagneticFields;
import net.arna.jcraft.common.tickable.RazorCoughs;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class RazorCoughAttack
extends AbstractMove<RazorCoughAttack, MetallicaEntity> {
    public RazorCoughAttack(int cooldown, int windup, int duration) {
        super(cooldown, windup, duration, 0.0f);
    }

    @Override
    @NonNull
    public MoveType<RazorCoughAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        HashSet<Object> filter = new HashSet<Object>(2);
        filter.add(user);
        filter.add(attacker);
        if (user.m_20160_()) {
            filter.addAll(user.m_20197_());
        }
        MagneticFields.forAllOfOwner((Entity)user, field -> {
            Set<LivingEntity> hit = JUtils.generateHitbox(attacker.m_9236_(), field.pos, field.getStrength(), filter);
            for (LivingEntity target : hit) {
                RazorCoughs.add(user, (Entity)target);
                target.m_216990_((SoundEvent)JSoundRegistry.METALLICA_RAZOR_VOMIT_PREPARE.get());
                int amplifier = 0;
                MobEffectInstance effect = target.m_21124_((MobEffect)JStatusRegistry.HYPOXIA.get());
                if (effect != null) {
                    amplifier = effect.m_19564_() + 1;
                }
                target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.HYPOXIA.get(), 400, amplifier));
                if (target instanceof Player) {
                    field.time = 0;
                    continue;
                }
                field.time -= 400;
            }
        });
        return Set.of();
    }

    @Override
    @NonNull
    protected RazorCoughAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public RazorCoughAttack copy() {
        return this.copyExtras(new RazorCoughAttack(this.getCooldown(), this.getWindup(), this.getDuration()));
    }

    public static class Type
    extends AbstractMove.Type<RazorCoughAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<RazorCoughAttack>, RazorCoughAttack> buildCodec(RecordCodecBuilder.Instance<RazorCoughAttack> instance) {
            return instance.group(this.extras(), this.cooldown(), this.windup(), this.duration()).apply(instance, this.applyExtras(RazorCoughAttack::new));
        }
    }
}

