/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.metallica;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.common.entity.projectile.ScalpelProjectile;
import net.arna.jcraft.common.entity.stand.MetallicaEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RemoteScalpelMove
extends AbstractMove<RemoteScalpelMove, MetallicaEntity> {
    public RemoteScalpelMove(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<RemoteScalpelMove> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(MetallicaEntity attacker, LivingEntity user) {
        Vec3 rotVec;
        Vec3 eyePos = user.m_20182_().m_82549_(GravityChangerAPI.getEyeOffset((Entity)user));
        HitResult hitResult = JUtils.raycastAll((Entity)user, eyePos, eyePos.m_82549_((rotVec = user.m_20154_()).m_82490_(12.0)), ClipContext.Fluid.NONE, EntitySelector.f_20403_);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return Set.of();
        }
        Vec3 hitPos = hitResult.m_82450_();
        Vec3 upVec = GravityChangerAPI.getEyeOffset((Entity)user);
        attacker.m_9236_().m_6263_(null, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, (SoundEvent)JSoundRegistry.METALLICA_SCALPEL_SUMMON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        for (int i = 1; i < 4; ++i) {
            ScalpelProjectile scalpel = ScalpelProjectile.fromMetallica(attacker);
            if (scalpel == null) continue;
            scalpel.setTempNoGrav();
            scalpel.m_146884_(hitPos.m_82549_(upVec.m_82490_(0.25 * (double)i)));
            scalpel.m_20256_(upVec.m_82490_(0.25));
            attacker.m_9236_().m_7967_((Entity)scalpel);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected RemoteScalpelMove getThis() {
        return this;
    }

    @Override
    @NonNull
    public RemoteScalpelMove copy() {
        return this.copyExtras(new RemoteScalpelMove(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<RemoteScalpelMove> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<RemoteScalpelMove>, RemoteScalpelMove> buildCodec(RecordCodecBuilder.Instance<RemoteScalpelMove> instance) {
            return this.baseDefault(instance, RemoteScalpelMove::new);
        }
    }
}

