/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.purplehaze;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractUppercutAttack;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class BackhandAttack
extends AbstractUppercutAttack<BackhandAttack, AbstractPurpleHazeEntity<?, ?>> {
    public BackhandAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, float strength) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, strength);
    }

    @Override
    @NonNull
    public MoveType<BackhandAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    protected void processTarget(AbstractPurpleHazeEntity<?, ?> attacker, LivingEntity target, Vec3 kbVec, DamageSource damageSource) {
        super.processTarget(attacker, target, kbVec, damageSource);
        boolean stillBlocking = JUtils.isBlocking(target);
        if (!stillBlocking) {
            AbstractPurpleHazeEntity.infect(target, 60);
        }
    }

    @Override
    @NonNull
    protected BackhandAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public BackhandAttack copy() {
        return this.copyExtras(new BackhandAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getStrength()));
    }

    public static class Type
    extends AbstractUppercutAttack.Type<BackhandAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<BackhandAttack>, BackhandAttack> buildCodec(RecordCodecBuilder.Instance<BackhandAttack> instance) {
            return this.uppercutDefault(instance, BackhandAttack::new);
        }
    }
}

