/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.purplehaze;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMultiHitAttack;
import net.arna.jcraft.common.attack.moves.purplehaze.LaunchCapsuleAttack;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;

public class FullReleaseAttack
extends AbstractMultiHitAttack<FullReleaseAttack, AbstractPurpleHazeEntity<?, ?>> {
    public FullReleaseAttack(int cooldown, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, @NonNull IntCollection hitMoments) {
        super(cooldown, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, hitMoments);
        if (hitMoments == null) {
            throw new NullPointerException("hitMoments is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public MoveType<FullReleaseAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AbstractPurpleHazeEntity<?, ?> attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        float baseYaw = user.m_146908_();
        Direction gravity = GravityChangerAPI.getGravityDirection(attacker);
        if (attacker.getMoveStun() == 6) {
            baseYaw += 60.0f;
        }
        for (int i = 0; i < 3; ++i) {
            LaunchCapsuleAttack.launchCapsule(attacker, user, gravity, 0.6f, baseYaw + (float)i * 120.0f);
        }
        return targets;
    }

    @Override
    @NonNull
    protected FullReleaseAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public FullReleaseAttack copy() {
        return this.copyExtras(new FullReleaseAttack(this.getCooldown(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), (IntCollection)this.getHitMoments()));
    }

    public static class Type
    extends AbstractMultiHitAttack.Type<FullReleaseAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<FullReleaseAttack>, FullReleaseAttack> buildCodec(RecordCodecBuilder.Instance<FullReleaseAttack> instance) {
            return this.multiHitDefault(instance, FullReleaseAttack::new);
        }
    }
}

