/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.purplehaze;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.entity.projectile.PHCapsuleProjectile;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.arna.jcraft.common.gravity.util.RotationUtil;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class LaunchCapsuleAttack
extends AbstractMove<LaunchCapsuleAttack, AbstractPurpleHazeEntity<?, ?>> {
    public LaunchCapsuleAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    public static void launchCapsule(AbstractPurpleHazeEntity<?, ?> attacker, LivingEntity user, Direction gravity, float speed, float yaw) {
        PHCapsuleProjectile capsule = new PHCapsuleProjectile(user, attacker.m_9236_(), attacker.getPoisonType());
        Vec2 corrected = RotationUtil.rotPlayerToWorld(yaw, user.m_146909_(), gravity);
        JUtils.shoot((Projectile)capsule, (Entity)user, corrected.f_82471_, corrected.f_82470_, 0.0f, speed, 0.1f);
        Vec3 heightOffset = GravityChangerAPI.getEyeOffset((Entity)attacker.getUserOrThrow()).m_82490_(0.5);
        capsule.m_146884_(attacker.getBaseEntity().m_20182_().m_82549_(heightOffset));
        attacker.m_9236_().m_7967_((Entity)capsule);
    }

    @Override
    @NonNull
    public MoveType<LaunchCapsuleAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AbstractPurpleHazeEntity<?, ?> attacker, LivingEntity user) {
        LivingEntity shooter = attacker.isRemote() && !attacker.remoteControllable() ? attacker : user;
        LaunchCapsuleAttack.launchCapsule(attacker, shooter, GravityChangerAPI.getGravityDirection((Entity)shooter), 0.8f, shooter.m_146908_());
        return Set.of();
    }

    @Override
    @NonNull
    protected LaunchCapsuleAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LaunchCapsuleAttack copy() {
        return this.copyExtras(new LaunchCapsuleAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<LaunchCapsuleAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<LaunchCapsuleAttack>, LaunchCapsuleAttack> buildCodec(RecordCodecBuilder.Instance<LaunchCapsuleAttack> instance) {
            return this.baseDefault(instance, LaunchCapsuleAttack::new);
        }
    }
}

