/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.purplehaze;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.common.attack.moves.purplehaze.LaunchCapsuleAttack;
import net.arna.jcraft.common.entity.stand.AbstractPurpleHazeEntity;
import net.arna.jcraft.common.gravity.api.GravityChangerAPI;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LaunchCapsulesAttack
extends AbstractMove<LaunchCapsulesAttack, AbstractPurpleHazeEntity<?, ?>> {
    public LaunchCapsulesAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
        this.ranged = true;
    }

    @Override
    @NonNull
    public MoveType<LaunchCapsulesAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(AbstractPurpleHazeEntity<?, ?> attacker, LivingEntity user) {
        LivingEntity shooter = attacker.isRemote() && !attacker.remoteControllable() ? attacker : user;
        Direction gravity = GravityChangerAPI.getGravityDirection((Entity)shooter);
        for (int i = 0; i < 3; ++i) {
            LaunchCapsuleAttack.launchCapsule(attacker, shooter, gravity, 0.4f, shooter.m_146908_() - 45.0f + (float)i * 45.0f);
        }
        return Set.of();
    }

    @Override
    @NonNull
    protected LaunchCapsulesAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public LaunchCapsulesAttack copy() {
        return this.copyExtras(new LaunchCapsulesAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<LaunchCapsulesAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<LaunchCapsulesAttack>, LaunchCapsulesAttack> buildCodec(RecordCodecBuilder.Instance<LaunchCapsulesAttack> instance) {
            return this.baseDefault(instance, LaunchCapsulesAttack::new);
        }
    }
}

