/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shadowtheworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.Attacks;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.component.living.CommonHitPropertyComponent;
import net.arna.jcraft.api.component.world.CommonShockwaveHandlerComponent;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.common.entity.stand.ShadowTheWorldEntity;
import net.arna.jcraft.common.util.JParticleType;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ImpalingThrustAttack
extends AbstractMove<ImpalingThrustAttack, ShadowTheWorldEntity> {
    public ImpalingThrustAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<ImpalingThrustAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(ShadowTheWorldEntity attacker, LivingEntity user) {
        ServerLevel world = (ServerLevel)attacker.m_9236_();
        CommonShockwaveHandlerComponent shockwaveHandler = JComponentPlatformUtils.getShockwaveHandler((Level)world);
        Vec3 start = user.m_146892_();
        Vec3 end = user.m_146892_().m_82549_(user.m_20154_().m_82490_(8.0));
        BlockHitResult hitResult = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)user));
        Vec3 pos2 = hitResult.m_82450_();
        Vec3 towardsVec = pos2.m_82546_(start);
        DamageSource playerSource = world.m_269111_().m_269333_(user);
        user.m_20324_(pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
        double count = Math.round(start.m_82554_(pos2));
        boolean hitAny = false;
        HashSet processed = new HashSet();
        int i = 0;
        while ((double)i < count) {
            Vec3 curPos = start.m_82549_(towardsVec.m_82490_((double)i / count));
            if (i % 3 == 0) {
                shockwaveHandler.addShockwave(curPos, towardsVec, 2.25f);
            }
            Vec3 vec1 = curPos.m_82520_(-1.0, -1.0, -1.0);
            Vec3 vec2 = curPos.m_82520_(1.0, 1.0, 1.0);
            JUtils.displayHitbox((Level)world, vec1, vec2);
            List hurt = world.m_6443_(LivingEntity.class, new AABB(vec1, vec2), EntitySelector.f_20406_.and(e -> e != attacker && e != user));
            hurt.removeIf(processed::contains);
            if (processed.addAll(hurt)) {
                hitAny = true;
                JCraft.createParticle(world, curPos.f_82479_ + attacker.m_217043_().m_188583_(), curPos.f_82480_ + attacker.m_217043_().m_188583_(), curPos.f_82481_ + attacker.m_217043_().m_188583_(), JParticleType.HIT_SPARK_2);
                for (LivingEntity ent : hurt) {
                    LivingEntity target = JUtils.getUserIfStand(ent);
                    Attacks.damageLogic((Level)world, target, target.m_20182_().m_82546_(curPos).m_82541_(), 10 + attacker.getDesummonTime(), 3, false, 8.0f, true, 12, playerSource, (Entity)user, CommonHitPropertyComponent.HitAnimation.LAUNCH);
                    target.m_7292_(new MobEffectInstance((MobEffect)JStatusRegistry.KNOCKDOWN.get(), 35, 0, true, false));
                }
            }
            ++i;
        }
        if (hitAny) {
            attacker.m_5496_((SoundEvent)JSoundRegistry.IMPACT_1.get(), 1.0f, 1.0f);
        }
        attacker.m_5496_((SoundEvent)JSoundRegistry.TIME_SKIP.get(), 1.0f, 1.0f);
        attacker.m_5496_((SoundEvent)JSoundRegistry.STW_ZAP.get(), 1.0f, 1.0f);
        return Set.of();
    }

    @Override
    @NonNull
    protected ImpalingThrustAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public ImpalingThrustAttack copy() {
        return this.copyExtras(new ImpalingThrustAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<ImpalingThrustAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ImpalingThrustAttack>, ImpalingThrustAttack> buildCodec(RecordCodecBuilder.Instance<ImpalingThrustAttack> instance) {
            return this.baseDefault(instance, ImpalingThrustAttack::new);
        }
    }
}

