/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shadowtheworld;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractCounterAttack;
import net.arna.jcraft.api.attack.moves.AbstractMove;
import net.arna.jcraft.api.registry.JSoundRegistry;
import net.arna.jcraft.api.registry.JStatusRegistry;
import net.arna.jcraft.api.spec.JSpec;
import net.arna.jcraft.common.attack.moves.shared.CounterMissMove;
import net.arna.jcraft.common.entity.stand.ShadowTheWorldEntity;
import net.arna.jcraft.common.network.s2c.PlayerAnimPacket;
import net.arna.jcraft.common.util.JUtils;
import net.arna.jcraft.platform.JComponentPlatformUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class STWCounterAttack
extends AbstractCounterAttack<STWCounterAttack, ShadowTheWorldEntity> {
    private static final CounterMissMove<ShadowTheWorldEntity> missAttack = new CounterMissMove(20);

    public STWCounterAttack(int cooldown, int windup, int duration, float moveDistance) {
        super(cooldown, windup, duration, moveDistance);
    }

    @Override
    @NonNull
    public MoveType<STWCounterAttack> getMoveType() {
        return Type.INSTANCE;
    }

    @Override
    public void onInitiate(ShadowTheWorldEntity attacker) {
        super.onInitiate(attacker);
        LivingEntity user = attacker.getUserOrThrow();
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            JSpec<?, ?> spec = JComponentPlatformUtils.getSpecData((LivingEntity)player).getSpec();
            if (spec != null) {
                spec.cancelMove();
            }
            JUtils.around((ServerLevel)player.m_9236_(), player.m_20182_(), 96.0).forEach(serverPlayer -> PlayerAnimPacket.send((Player)player, serverPlayer, "stw.cntr"));
        }
        JCraft.stun(user, 20, 0);
    }

    @Override
    public void whiff(@NonNull ShadowTheWorldEntity attacker, @NonNull LivingEntity user) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        attacker.cancelMove();
        attacker.desummon(false);
        JCraft.stun(user, missAttack.getDuration(), 0);
    }

    @Override
    public void counter(@NonNull ShadowTheWorldEntity attacker, Entity countered, DamageSource counteredDamageSource) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        super.counter(attacker, countered, counteredDamageSource);
        if (countered == null || !attacker.hasUser()) {
            return;
        }
        LivingEntity user = attacker.getUserOrThrow();
        Vec3 behind = countered.m_20182_().m_82546_(countered.m_20154_());
        BlockPos behindBlockPos = new BlockPos((int)behind.f_82479_, (int)behind.f_82480_, (int)behind.f_82481_);
        JUtils.setVelocity((Entity)user, 0.0, 0.0, 0.0);
        if (!user.m_9236_().m_8055_(behindBlockPos).m_60815_()) {
            user.m_20324_(behind.f_82479_, behind.f_82480_, behind.f_82481_);
        }
        user.m_7618_(EntityAnchorArgument.Anchor.EYES, countered.m_146892_());
        if (countered instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)countered;
            livingEntity.m_21195_((MobEffect)JStatusRegistry.DAZED.get());
            JCraft.stun(livingEntity, 20, 0);
            JUtils.cancelMoves(livingEntity);
        }
        attacker.m_5496_((SoundEvent)JSoundRegistry.STW_LAUGH.get(), 1.0f, 1.0f);
        attacker.m_5496_((SoundEvent)JSoundRegistry.STW_ZAP.get(), 1.0f, 1.0f);
        attacker.cancelMove();
        attacker.desummon();
    }

    @Override
    @NonNull
    protected STWCounterAttack getThis() {
        return this;
    }

    @Override
    @NonNull
    public STWCounterAttack copy() {
        return this.copyExtras(new STWCounterAttack(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance()));
    }

    public static class Type
    extends AbstractMove.Type<STWCounterAttack> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<STWCounterAttack>, STWCounterAttack> buildCodec(RecordCodecBuilder.Instance<STWCounterAttack> instance) {
            return this.baseDefault(instance, STWCounterAttack::new);
        }
    }
}

