/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.enums.StunType;
import net.arna.jcraft.api.attack.moves.AbstractBarrageAttack;
import net.arna.jcraft.api.attack.moves.AbstractChargeAttack;
import net.arna.jcraft.api.stand.StandEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class ChargeBarrageAttack<A extends IAttacker<? extends A, ?>>
extends AbstractBarrageAttack<ChargeBarrageAttack<A>, A> {
    private final float originalMoveDistance;
    private final boolean quadraticMovement;

    public ChargeBarrageAttack(int cooldown, int windup, int duration, float moveDistance, float damage, int stun, float hitboxSize, float knockback, float offset, int interval, boolean quadraticMovement) {
        super(cooldown, windup, duration, moveDistance, damage, stun, hitboxSize, knockback, offset, interval);
        this.originalMoveDistance = moveDistance;
        this.quadraticMovement = quadraticMovement;
        this.withStunType(StunType.BURSTABLE);
        this.copyOnUse = true;
        this.charge = true;
        this.ranged = true;
        this.inflictsSlowness = false;
    }

    @Override
    @NonNull
    public MoveType<ChargeBarrageAttack<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    public void onInitiate(A attacker) {
        super.onInitiate(attacker);
        this.withMoveDistance(this.originalMoveDistance);
    }

    @Override
    public void activeTick(A attacker, int moveStun) {
        super.activeTick(attacker, moveStun);
        LivingEntity attackerEntity = attacker.getBaseEntity();
        if (attackerEntity instanceof StandEntity) {
            StandEntity stand = (StandEntity)attackerEntity;
            this.tickChargeBarrageAttack(stand, moveStun < this.getWindupPoint(), this.getMoveDistance(), this.getWindupPoint(), moveStun);
        } else {
            JCraft.LOGGER.error("Trying to tick ChargeBarrageAttack on non-stand entity; {}", (Object)attackerEntity);
        }
    }

    private Vec3 advanceChargePos(StandEntity<?, ?> attacker, float moveDistance, int windupPoint, int moveStun) {
        if (this.quadraticMovement) {
            return attacker.m_20182_().m_82549_(ChargeBarrageAttack.getRotVec(attacker).m_82490_((double)(moveDistance * (float)moveStun / (float)(windupPoint * windupPoint))));
        }
        return attacker.m_20182_().m_82549_(ChargeBarrageAttack.getRotVec(attacker).m_82490_((double)(moveDistance / (float)windupPoint)));
    }

    private void tickChargeBarrageAttack(StandEntity<?, ?> attacker, boolean shouldPerform, float moveDistance, int windupPoint, int moveStun) {
        if (shouldPerform) {
            Vec3 newPos = this.advanceChargePos(attacker, moveDistance, windupPoint, moveStun);
            attacker.setFreePos(new Vector3f((float)newPos.f_82479_, (float)newPos.f_82480_, (float)newPos.f_82481_));
            attacker.setFree(true);
        } else {
            AbstractChargeAttack.prepDetachmentMove(attacker, attacker.getUserOrThrow());
        }
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        Set<LivingEntity> targets = super.perform(attacker, user);
        LivingEntity attackerEntity = attacker.getBaseEntity();
        if (targets.isEmpty() || attackerEntity == null) {
            return targets;
        }
        Vec3 avgPos = Vec3.f_82478_;
        float c = 0.0f;
        for (LivingEntity target : targets) {
            if (target instanceof StandEntity) continue;
            avgPos = avgPos.m_82549_(target.m_20182_());
            c += 1.0f;
        }
        avgPos = avgPos.m_82490_((double)(1.0f / c));
        attackerEntity.m_7618_(EntityAnchorArgument.Anchor.EYES, avgPos);
        this.withMoveDistance((float)avgPos.m_82557_(attackerEntity.m_20182_()) + 0.1f);
        return targets;
    }

    @Override
    protected Vec3 getOffsetForwardPos(A attacker, Vec3 offsetHeightPos, Vec3 upVec, Vec3 rotVec) {
        return offsetHeightPos.m_82549_(rotVec);
    }

    @Override
    @NonNull
    protected ChargeBarrageAttack<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public ChargeBarrageAttack<A> copy() {
        return this.copyExtras(new ChargeBarrageAttack<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getDamage(), this.getStun(), this.getHitboxSize(), this.getKnockback(), this.getOffset(), this.getInterval(), this.quadraticMovement));
    }

    public boolean isQuadraticMovement() {
        return this.quadraticMovement;
    }

    public static class Type
    extends AbstractBarrageAttack.Type<ChargeBarrageAttack<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<ChargeBarrageAttack<?>>, ChargeBarrageAttack<?>> buildCodec(RecordCodecBuilder.Instance<ChargeBarrageAttack<?>> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.damage(), this.stun(), this.hitboxSize(), this.knockback(), this.offset(), this.interval(), (App)Codec.BOOL.fieldOf("quadratic_movement").forGetter(ChargeBarrageAttack::isQuadraticMovement)).apply(instance, this.applyAttackExtras(ChargeBarrageAttack::new));
        }
    }
}

