/*
 * Decompiled with CFR 0.152.
 */
package net.arna.jcraft.common.attack.moves.shared;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.arna.jcraft.JCraft;
import net.arna.jcraft.api.attack.IAttacker;
import net.arna.jcraft.api.attack.MoveType;
import net.arna.jcraft.api.attack.moves.AbstractSimpleAttack;
import net.arna.jcraft.common.util.JCodecUtils;
import net.arna.jcraft.common.util.JUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public final class HealMove<A extends IAttacker<? extends A, ?>>
extends AbstractSimpleAttack<HealMove<A>, A> {
    private final float health;
    private final HealTarget target;
    private final boolean pacifyMobs;

    public HealMove(int cooldown, int windup, int duration, float moveDistance, float hitboxSize, float offset, float health, HealTarget target, boolean pacifyMobs) {
        super(cooldown, windup, duration, moveDistance, 0.0f, 0, hitboxSize, 0.0f, offset);
        this.health = health;
        this.target = target;
        this.pacifyMobs = pacifyMobs;
    }

    @Override
    @NonNull
    public MoveType<HealMove<A>> getMoveType() {
        return Type.INSTANCE.cast();
    }

    @Override
    @NonNull
    public Set<LivingEntity> perform(A attacker, LivingEntity user) {
        ServerLevel world;
        BlockHitResult hitResult;
        Set<LivingEntity> targets = this.target.pickTargets(super.perform(attacker, user), user);
        targets.forEach(e -> {
            e.m_5634_(this.health);
            if (this.pacifyMobs) {
                HealMove.pacifyMob(e);
            }
        });
        if (this.target == HealTarget.TARGETS && attacker.getUserOrThrow().m_6144_() && (hitResult = JUtils.genericBlockRaycast((Level)(world = (ServerLevel)user.m_9236_()), (Entity)user, 2.0, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE)).m_6662_() == HitResult.Type.BLOCK) {
            BonemealableBlock fertilizable;
            BlockPos blockPos = hitResult.m_82425_();
            BlockState blockState = world.m_8055_(blockPos);
            boolean fertilized = false;
            Block block = blockState.m_60734_();
            if (block instanceof BonemealableBlock && (fertilizable = (BonemealableBlock)block).m_7370_((LevelReader)world, blockPos, blockState, false) && fertilizable.m_214167_((Level)world, world.f_46441_, blockPos, blockState)) {
                for (int i = 0; i < 5; ++i) {
                    fertilizable.m_214148_(world, world.f_46441_, blockPos, blockState);
                }
                fertilized = true;
            }
            if (!fertilized) {
                BoneMealItem.m_40631_((ItemStack)new ItemStack((ItemLike)Items.f_41852_), (Level)world, (BlockPos)blockPos, (Direction)Direction.DOWN);
            }
            world.m_46796_(1505, blockPos, 0);
        }
        return targets;
    }

    private static void pacifyMob(LivingEntity target) {
        target.m_6703_(null);
        if (!(target instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)target;
        JCraft.stun((LivingEntity)mob, 10, 0);
        mob.m_6710_(null);
        mob.m_6598_(null);
        if (mob instanceof NeutralMob) {
            NeutralMob angerable = (NeutralMob)mob;
            angerable.m_21662_();
        }
    }

    @Override
    @NonNull
    protected HealMove<A> getThis() {
        return this;
    }

    @Override
    @NonNull
    public HealMove<A> copy() {
        return this.copyExtras(new HealMove<A>(this.getCooldown(), this.getWindup(), this.getDuration(), this.getMoveDistance(), this.getHitboxSize(), this.getOffset(), this.health, this.target, this.pacifyMobs));
    }

    public float getHealth() {
        return this.health;
    }

    public HealTarget getTarget() {
        return this.target;
    }

    public boolean isPacifyMobs() {
        return this.pacifyMobs;
    }

    public static enum HealTarget {
        TARGETS((targets, user) -> targets),
        USER((targets, user) -> Set.of(user));

        public static final Codec<HealTarget> CODEC;
        private final BiFunction<Set<LivingEntity>, LivingEntity, Set<LivingEntity>> targetPicker;

        private HealTarget(BiFunction<Set<LivingEntity>, LivingEntity, Set<LivingEntity>> targetPicker) {
            this.targetPicker = targetPicker;
        }

        public Set<LivingEntity> pickTargets(Set<LivingEntity> targets, LivingEntity user) {
            return this.targetPicker.apply(targets, user);
        }

        static {
            CODEC = JCodecUtils.createEnumCodec(HealTarget.class);
        }
    }

    public static class Type
    extends AbstractSimpleAttack.Type<HealMove<?>> {
        public static final Type INSTANCE = new Type();

        @Override
        @NonNull
        protected App<RecordCodecBuilder.Mu<HealMove<?>>, HealMove<?>> buildCodec(RecordCodecBuilder.Instance<HealMove<?>> instance) {
            return instance.group(this.extras(), this.attackExtras(), this.cooldown(), this.windup(), this.duration(), this.moveDistance(), this.hitboxSize(), this.offset(), (App)Codec.FLOAT.fieldOf("health").forGetter(HealMove::getHealth), (App)HealTarget.CODEC.fieldOf("target").forGetter(HealMove::getTarget), (App)Codec.BOOL.fieldOf("pacify_mobs").forGetter(HealMove::isPacifyMobs)).apply(instance, this.applyAttackExtras(HealMove::new));
        }
    }
}

